/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.ContentSourceType;
import org.rhq.core.domain.content.DownloadMode;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.CreateContentSourceUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ContentException;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.perspective.PerspectiveManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class CreateContentSourceUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "CreateContentSourceUIBean";
    private ContentSourceManagerLocal contentSourceManager = LookupUtil.getContentSourceManager();
    private PerspectiveManagerLocal perspectiveManager = LookupUtil.getPerspectiveManager();
    private ContentSource newContentSource = new ContentSource();
    private ContentSourceType selectedContentSourceType = null;

    public ConfigurationDefinition getContentSourceTypeConfigurationDefinition() {
        return this.selectedContentSourceType != null ? this.selectedContentSourceType.getContentSourceConfigurationDefinition() : null;
    }

    public SelectItem[] getDownloadModes() {
        DownloadMode[] modes = DownloadMode.values();
        SelectItem[] items = new SelectItem[modes.length];
        int i = 0;
        for (DownloadMode mode : modes) {
            items[i++] = new SelectItem((Object)mode.name());
        }
        return items;
    }

    public String getSelectedDownloadMode() {
        return this.newContentSource.getDownloadMode().name();
    }

    public void setSelectedDownloadMode(String mode) {
        this.newContentSource.setDownloadMode(DownloadMode.valueOf((String)mode));
    }

    public ContentSource getContentSource() {
        HttpServletRequest request = FacesContextUtility.getRequest();
        if ("new".equals(request.getParameter("mode"))) {
            this.newContentSource = new ContentSource();
            this.updateSelectedContentSourceType(this.selectedContentSourceType);
        }
        return this.newContentSource;
    }

    public void setContentSource(ContentSource newContentSource) {
        this.newContentSource = newContentSource;
    }

    public String getNullConfigurationDefinitionMessage() {
        return "The selected content source type does not require a configuration.";
    }

    public String getNullConfigurationMessage() {
        return "Content source has an empty configuration.";
    }

    public String save() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        ContentSourceManagerLocal manager = LookupUtil.getContentSourceManager();
        try {
            ContentSource created = manager.createContentSource(subject, this.newContentSource);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Saved [" + created.getName() + "] with the ID of [" + created.getId() + "]"));
        }
        catch (ContentException ce) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Error: " + ce.getMessage()));
            return "edit";
        }
        this.selectedContentSourceType = null;
        this.newContentSource = new ContentSource();
        return "save";
    }

    public String cancel() {
        this.selectedContentSourceType = null;
        this.newContentSource = new ContentSource();
        return "cancel";
    }

    private void updateSelectedContentSourceType(ContentSourceType cst) {
        if (cst == null) {
            this.selectedContentSourceType = null;
            this.newContentSource.setContentSourceType(null);
        } else if (!cst.equals((Object)this.newContentSource.getContentSourceType())) {
            this.selectedContentSourceType = cst;
            this.newContentSource.setContentSourceType(cst);
            if (cst.getContentSourceConfigurationDefinition() == null) {
                this.newContentSource.setConfiguration(null);
            } else {
                ConfigurationTemplate defaultTemplate = cst.getContentSourceConfigurationDefinition().getDefaultTemplate();
                if (defaultTemplate != null) {
                    this.newContentSource.setConfiguration(defaultTemplate.createConfiguration());
                } else {
                    this.newContentSource.setConfiguration(new Configuration());
                }
            }
            this.newContentSource.setSyncSchedule(cst.getDefaultSyncSchedule());
            this.newContentSource.setLazyLoad(cst.isDefaultLazyLoad());
            this.newContentSource.setDownloadMode(cst.getDefaultDownloadMode());
        }
    }

    public String finishAddMap() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Map added.");
        return "success";
    }

    public String finishEditMap() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Map updated.");
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListContentSourceTypesDataModel(this, PageControlView.NONE, MANAGED_BEAN_NAME);
        } else {
            String typeName = FacesContextUtility.getOptionalRequestParameter((String)"typeName");
            if (typeName != null && (this.selectedContentSourceType == null || this.selectedContentSourceType != null && !typeName.equals(this.selectedContentSourceType.getName()))) {
                this.selectedContentSourceType = this.contentSourceManager.getContentSourceType(typeName);
                this.updateSelectedContentSourceType(this.selectedContentSourceType);
            }
        }
        return this.dataModel;
    }

    public String getCreateContentProviderPageLink(String typeName) {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String link = this.perspectiveManager.getPageLink(subject, "createContentProvider", typeName, null);
        link = null == link ? "/rhq/content/createContentProvider.xhtml?mode=new&typeName=" + typeName : link + "&mode=new&typeName=" + typeName;
        return link;
    }

    static /* synthetic */ ContentSourceManagerLocal access$000(CreateContentSourceUIBean x0) {
        return x0.contentSourceManager;
    }
}

