/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIData;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.content.ContentUtils;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.ContentUIManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class InstallationStepsUIBean {
    private int selectedPackageId;
    private PackageVersion packageVersion;
    private List<DeployPackageStep> deploySteps;
    private UIData stepsData;
    private final Log log = LogFactory.getLog(this.getClass());

    public String loadSteps() {
        ContentUIManagerLocal contentUIManager = LookupUtil.getContentUIManager();
        ContentManagerLocal contentManager = LookupUtil.getContentManager();
        HttpServletRequest request = FacesContextUtility.getRequest();
        this.selectedPackageId = Integer.parseInt(request.getParameter("selectedPackageId"));
        this.log.info((Object)("Loading package version for ID: " + this.selectedPackageId));
        this.packageVersion = contentUIManager.getPackageVersion(this.selectedPackageId);
        Resource resource = EnterpriseFacesContextUtility.getResource();
        ResourcePackageDetails details = ContentUtils.toResourcePackageDetails((PackageVersion)this.packageVersion);
        try {
            this.deploySteps = contentManager.translateInstallationSteps(resource.getId(), details);
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Could not retrieve installation steps", (Throwable)e);
        }
        this.log.info((Object)("Translated number of steps: " + (this.deploySteps != null ? Integer.valueOf(this.deploySteps.size()) : null)));
        return "loadedSteps";
    }

    public List<DeployPackageStep> getDeploySteps() {
        return this.deploySteps;
    }

    public UIData getStepsData() {
        return this.stepsData;
    }

    public void setStepsData(UIData stepsData) {
        this.stepsData = stepsData;
    }

    public int getSelectedPackageId() {
        return this.selectedPackageId;
    }

    public void setSelectedPackageId(int selectedPackageId) {
        this.selectedPackageId = selectedPackageId;
    }

    public PackageVersion getPackageVersion() {
        return this.packageVersion;
    }

    public void setPackageVersion(PackageVersion packageVersion) {
        this.packageVersion = packageVersion;
    }
}

