/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import java.util.ArrayList;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import javax.faces.model.SelectItem;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.composite.OptionItem;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.converter.SelectItemUtils;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.RepoImportUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ContentSourceManagerLocal;
import org.rhq.enterprise.server.content.RepoException;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class RepoImportUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "RepoImportUIBean";
    private int selectedProvider = 0;
    private List<OptionItem<Integer>> providers = null;

    public String getProviderName() {
        for (OptionItem item : this.providers) {
            if ((Integer)item.getId() != this.selectedProvider) continue;
            return item.getDisplayName();
        }
        return "";
    }

    public String getSelectedProvider() {
        return String.valueOf(this.selectedProvider);
    }

    public void setSelectedProvider(String selectedProvider) {
        this.dataModel = null;
        this.selectedProvider = Integer.valueOf(selectedProvider);
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ImportRepDataModel(this, PageControlView.ReposToImportList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    public SelectItem[] getProviderOptions() {
        if (this.providers == null) {
            this.providers = new ArrayList();
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            ContentSourceManagerLocal manager = LookupUtil.getContentSourceManager();
            PageControl pc = new PageControl();
            PageList results = manager.getAllContentSources(subject, pc);
            for (ContentSource p : results) {
                OptionItem item = new OptionItem((Object)p.getId(), p.getName());
                this.providers.add(item);
            }
        }
        return SelectItemUtils.convertFromListOptionItem((List)this.providers, (boolean)false);
    }

    public String[] getSelectedRepos() {
        return FacesContextUtility.getRequest().getParameterValues("selectedRepos");
    }

    public String importSelected() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedRepos();
        ArrayList<Integer> repoIds = new ArrayList<Integer>(selected.length);
        for (String sRepoId : selected) {
            repoIds.add(Integer.valueOf(sRepoId));
        }
        RepoManagerLocal repoManager = LookupUtil.getRepoManagerLocal();
        try {
            repoManager.importCandidateRepo(subject, repoIds);
        }
        catch (RepoException e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to import one or more Repositories from " + this.getProviderName()), (Throwable)e);
            return "failed";
        }
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("[" + selected.length + "] Repositories imported from " + this.getProviderName()));
        return "success";
    }

    static /* synthetic */ int access$000(RepoImportUIBean x0) {
        return x0.selectedProvider;
    }
}

