/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.ha;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.ha.ListServersUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.cloud.CloudManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ListServersUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ListServersUIBean";
    private CloudManagerLocal cloudManager = LookupUtil.getCloudManager();

    public String removeSelectedServers() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selected = this.getSelectedServers();
        Integer[] ids = this.getIntegerArray(selected);
        if (ids.length > 0) {
            try {
                this.cloudManager.deleteServers(ids);
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Removed [" + ids.length + "] servers from the cloud."));
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to remove selected servers.", (Throwable)e);
            }
        } else {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)"No servers selected.");
        }
        return "success";
    }

    public String setSelectedServersMode(Server.OperationMode mode) {
        String[] selected = this.getSelectedServers();
        Integer[] ids = this.getIntegerArray(selected);
        if (ids.length > 0) {
            try {
                this.cloudManager.updateServerMode(ids, mode);
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Set [" + ids.length + "] servers to mode " + mode));
            }
            catch (Exception e) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to set selected server modes", (Throwable)e);
            }
        }
        return "success";
    }

    public String setSelectedServersModeMaintenance() {
        return this.setSelectedServersMode(Server.OperationMode.MAINTENANCE);
    }

    public String setSelectedServersModeNormal() {
        return this.setSelectedServersMode(Server.OperationMode.NORMAL);
    }

    public DataModel getDataModel() {
        if (null == this.dataModel) {
            this.dataModel = new ListServersDataModel(this, PageControlView.ServersList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedServers() {
        return FacesContextUtility.getRequest().getParameterValues("selectedServers");
    }

    private Integer[] getIntegerArray(String[] input) {
        if (input == null) {
            return new Integer[0];
        }
        Integer[] output = new Integer[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Integer.valueOf(input[i]);
        }
        return output;
    }

    static /* synthetic */ CloudManagerLocal access$000(ListServersUIBean x0) {
        return x0.cloudManager;
    }
}

