/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image.chart;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import org.rhq.enterprise.gui.image.chart.ChartGraphics;
import org.rhq.enterprise.gui.image.chart.DataPointCollection;
import org.rhq.enterprise.gui.image.chart.VerticalChart;
import org.rhq.enterprise.gui.image.data.IDataPoint;
import org.rhq.enterprise.gui.image.data.IHighLowDataPoint;

public class ColumnChart
extends VerticalChart {
    protected static final int DEFAULT_COLUMN_WIDTH = 5;
    protected static final Color DEFAULT_COLUMN_COLOR = new Color(102, 153, 255);
    protected static final Color DEFAULT_HIGHLOW_COLOR = new Color(102, 102, 102);
    public int columnWidth = 5;
    public Color columnColor = DEFAULT_COLUMN_COLOR;
    public boolean isCumulative = false;

    public ColumnChart() {
    }

    public ColumnChart(int width, int height) {
        super(width, height);
    }

    protected void init() {
        super.init();
        this.columnWidth = 5;
        this.valueIndent = 8;
    }

    protected void paint(ChartGraphics g, Rectangle rect) {
        int halfcol = this.columnWidth / 2;
        Rectangle rectBar = new Rectangle();
        rectBar.width = this.columnWidth;
        DataPointCollection coll = this.getDataPoints();
        Iterator iter = coll.iterator();
        int index = 0;
        while (iter.hasNext()) {
            IDataPoint datapt = (IDataPoint)iter.next();
            Point ptData = this.getDataPoint(rect, index, coll);
            if (ptData != null) {
                IHighLowDataPoint hlPt;
                rectBar.x = ptData.x - halfcol;
                rectBar.y = ptData.y;
                rectBar.height = rect.y + rect.height - rectBar.y;
                g.graphics.setColor(this.columnColor);
                g.graphics.fillRect(rectBar.x, rectBar.y, rectBar.width, rectBar.height);
                if (datapt instanceof IHighLowDataPoint && (hlPt = (IHighLowDataPoint)datapt).getHighValue() != hlPt.getLowValue()) {
                    Point ptHigh = this.adjustBorders(this.getDisplayPoint(rect.height, rect.width, coll.size(), hlPt.getHighValue(), index));
                    Point ptLow = this.adjustBorders(this.getDisplayPoint(rect.height, rect.width, coll.size(), hlPt.getLowValue(), index));
                    if (ptLow.y - ptHigh.y >= 2) {
                        g.graphics.setColor(DEFAULT_HIGHLOW_COLOR);
                        g.graphics.drawLine(ptLow.x, ptLow.y, ptHigh.x, ptHigh.y);
                        ptHigh.x -= halfcol;
                        ptLow.x -= halfcol;
                        g.graphics.drawLine(ptHigh.x, ptHigh.y, ptHigh.x + rectBar.width - 1, ptHigh.y);
                        g.graphics.drawLine(ptLow.x, ptLow.y, ptLow.x + rectBar.width - 1, ptLow.y);
                    }
                }
            }
            ++index;
        }
    }

    protected boolean checkHighLow() {
        return true;
    }
}

