/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image.chart;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.server.MeasurementConverter;
import org.rhq.enterprise.gui.image.chart.Chart;
import org.rhq.enterprise.gui.image.chart.ChartGraphics;
import org.rhq.enterprise.gui.image.chart.DataPointCollection;
import org.rhq.enterprise.gui.image.data.IDisplayDataPoint;

public class HorizontalChart
extends Chart {
    private Rectangle m_rect;

    protected HorizontalChart() {
        this.init();
    }

    protected HorizontalChart(int width, int height) {
        super(width, height);
        this.init();
    }

    protected HorizontalChart(int width, int height, int charts) {
        super(width, height, charts);
        this.init();
    }

    protected void init() {
        this.showUnitLines = true;
    }

    protected Rectangle adjustRectangle(Graphics2D g, Rectangle rect) {
        int cDataPts = this.getDataPoints().size();
        int iSpread = this.getUnitSpread(g, rect);
        rect.height = iSpread * (cDataPts - 1) + this.valueIndent * 2 + this.lineWidth;
        this.m_rect = rect;
        return rect;
    }

    protected Rectangle getInteriorRectangle(ChartGraphics g) {
        return this.m_rect;
    }

    protected String[] getUnitLabels() {
        DataPointCollection coll = this.getDataPoints();
        Iterator iter = coll.iterator();
        String[] result = new String[coll.size()];
        int i = 0;
        while (iter.hasNext()) {
            result[i] = ((IDisplayDataPoint)iter.next()).getLabel();
            ++i;
        }
        return result;
    }

    protected String[] getXLabels() {
        if (this.m_adRangeMarks == null) {
            return null;
        }
        String[] result = MeasurementConverter.formatToSignificantPrecision((double[])this.m_adRangeMarks, (MeasurementUnits)this.m_fmtUnits, (boolean)true);
        return result;
    }

    private int getUnitSpread(Graphics2D g, Rectangle rect) {
        int cDataPts = this.getDataPoints().size();
        int iSpread = rect.height - this.valueIndent * 2;
        return cDataPts > 1 ? iSpread / (cDataPts - 1) : iSpread;
    }

    protected int getYLabelWidth(Graphics2D g) {
        int maxWidth = 0;
        String[] labels = this.getUnitLabels();
        for (int i = 0; i < labels.length; ++i) {
            int labelWidth = this.m_metricsLabel.stringWidth(labels[i]);
            if (labelWidth <= maxWidth) continue;
            maxWidth = labelWidth;
        }
        return maxWidth;
    }

    protected Rectangle draw(ChartGraphics g) {
        Rectangle rect = super.draw(g);
        if (!this.hasData()) {
            return rect;
        }
        double dScale = this.scale(rect.width);
        if (this.showLeftLegend) {
            g.drawYLegendString(this.getUnitLegend());
        }
        DataPointCollection coll = this.getDataPoints();
        int[] lines = new int[coll.size()];
        String[] labels = this.getUnitLabels();
        int spread = this.getUnitSpread(g.graphics, rect);
        int i = 0;
        int y = rect.y + rect.height - this.valueIndent;
        while (i < coll.size()) {
            lines[i] = y;
            ++i;
            y -= spread;
        }
        g.drawXLines(lines, labels, false);
        labels = this.getXLabels();
        lines = new int[this.m_adRangeMarks.length];
        for (i = 0; i < this.m_adRangeMarks.length; ++i) {
            lines[i] = rect.x + (int)Math.round((this.m_adRangeMarks[i] - this.m_floor) * dScale);
        }
        g.drawYLines(lines, labels, true, this.xLabelsSkip);
        g.drawXLegendString(this.getValueLegend());
        if (this.showValues) {
            this.paint(g, rect);
        }
        return rect;
    }

    protected void paint(ChartGraphics g, Rectangle rect) {
    }

    protected Point getDataPoint(Rectangle rect, int datapoint) {
        return this.getDataPoint(rect, datapoint, this.getDataPoints());
    }

    protected Point getDataPoint(Rectangle rect, int datapoint, DataPointCollection coll) {
        Point ptResult = super.getDataPoint(rect.width, rect.height, datapoint, coll);
        if (ptResult != null) {
            ptResult = new Point(rect.x + (rect.width - ptResult.y), rect.y + ptResult.x);
        }
        return ptResult;
    }
}

