/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.image.widget;

import org.rhq.enterprise.gui.image.data.IResourceTreeNode;
import org.rhq.enterprise.gui.image.data.ITreeNode;
import org.rhq.enterprise.gui.image.widget.TreeNode;

public class ResourceTreeNode
extends TreeNode
implements IResourceTreeNode {
    private int m_type;

    public ResourceTreeNode(String name, String desc) {
        this(name, desc, false, 0);
    }

    public ResourceTreeNode(String name, int type) {
        this(name, null, false, type);
    }

    public ResourceTreeNode(String name, String desc, int type) {
        this(name, desc, false, type);
    }

    public ResourceTreeNode(String name, String desc, boolean selected) {
        this(name, desc, selected, 0);
    }

    public ResourceTreeNode(String name, String desc, boolean selected, int type) {
        super(name, desc, selected);
        if (!this.isValidType(type)) {
            throw new IllegalArgumentException("Invalid Type: " + type);
        }
        this.m_type = type;
    }

    public ITreeNode[] getUpChildren() {
        return this.m_upChildren.toArray(new IResourceTreeNode[this.m_upChildren.size()]);
    }

    public ITreeNode[] getDownChildren() {
        return this.m_downChildren.toArray(new IResourceTreeNode[this.m_downChildren.size()]);
    }

    public int getType() {
        return this.m_type;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[").append(" name=").append(this.getName()).append(" desc=").append(this.getDescription()).append(" type=").append(this.getType()).append(" up-children: ").append(this.getUpChildren()).append(" down-chilren: ").append(this.getDownChildren()).append(" ]");
        return buf.toString();
    }

    private boolean isValidType(int type) {
        return type >= 0 && type <= 3;
    }
}

