/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.autogroup;

import java.util.List;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.util.LookupUtil;

public class AutoGroupUIBean {
    public static final String MANAGED_BEAN_NAME = "AutoGroupUIBean";
    EntityContext context;
    private Resource parentResource;
    private ResourceType childResourceType;
    private Subject subject = EnterpriseFacesContextUtility.getSubject();
    private boolean measurementManager;

    public AutoGroupUIBean() {
        this.context = WebUtility.getEntityContext();
        this.parentResource = LookupUtil.getResourceManager().getResourceById(this.subject, this.context.getParentResourceId());
        try {
            this.childResourceType = LookupUtil.getResourceTypeManager().getResourceTypeById(this.subject, this.context.getResourceTypeId());
        }
        catch (ResourceTypeNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        this.measurementManager = this.determineMeasurementManager();
    }

    public boolean isMeasurementManager() {
        return this.measurementManager;
    }

    public Resource getParentResource() {
        return this.parentResource;
    }

    public ResourceType getChildResourceType() {
        return this.childResourceType;
    }

    private boolean determineMeasurementManager() {
        AuthorizationManagerLocal authManager = LookupUtil.getAuthorizationManager();
        if (authManager.isInventoryManager(this.subject)) {
            return true;
        }
        List resources = LookupUtil.getResourceGroupManager().findResourcesForAutoGroup(this.subject, this.getParentResource().getId(), this.getChildResourceType().getId());
        for (Resource resource : resources) {
            if (authManager.hasResourcePermission(this.subject, Permission.MANAGE_MEASUREMENTS, resource.getId())) continue;
            return false;
        }
        return true;
    }
}

