/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.gui.inventory.resource.ResourceUIBean;
import org.rhq.enterprise.gui.legacy.action.BaseDispatchAction;
import org.rhq.enterprise.gui.legacy.util.ActionUtils;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceNotFoundException;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public abstract class ResourceController
extends BaseDispatchAction {
    private final Log log = LogFactory.getLog(ResourceController.class);

    protected void setResource(HttpServletRequest request) throws Exception {
        this.setResource(request, false);
    }

    protected void setResource(HttpServletRequest request, boolean config) throws Exception {
        try {
            Subject subject = WebUtility.getSubject((HttpServletRequest)request);
            Integer resourceTypeId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"type", (int)-1);
            int groupId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"groupId", (int)-1);
            int parent = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"parent", (int)-1);
            String[] r = request.getParameterValues("r");
            String[] resourceIds = request.getParameterValues("resourceIds");
            if (resourceTypeId > 0 && parent > 0) {
                ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
                ResourceType resourceType = resourceTypeManager.getResourceTypeById(subject, resourceTypeId.intValue());
                request.setAttribute("ResourceType", (Object)resourceType);
                request.setAttribute("TitleParam", (Object)resourceType.getName());
                request.setAttribute("parent", (Object)parent);
                request.setAttribute("type", (Object)resourceTypeId);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Autogroup p=" + parent + ", ct=" + resourceTypeId));
                }
            } else if (groupId > 0) {
                ResourceGroupManagerLocal resourceGroupManager = LookupUtil.getResourceGroupManager();
                ResourceGroup group = resourceGroupManager.getResourceGroupById(subject, groupId, null);
                request.setAttribute("groupId", (Object)groupId);
                request.setAttribute("TitleParam", (Object)group.getName());
            } else if (resourceTypeId > 0 && parent == -1) {
                ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
                ResourceType resourceType = resourceTypeManager.getResourceTypeById(subject, resourceTypeId.intValue());
                request.setAttribute("ResourceType", (Object)resourceType);
                request.setAttribute("type", (Object)resourceTypeId);
            } else if (r != null && r.length > 0) {
                this.log.trace((Object)"Multiple resources not handled yet");
            } else if (resourceIds != null && resourceIds.length > 0) {
                this.log.trace((Object)"Multiple resources not yet handled");
            } else {
                Integer resourceId = WebUtility.getRequiredIntRequestParameter((ServletRequest)request, (String)"id");
                ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
                Resource resource = resourceManager.getResourceById(subject, resourceId.intValue());
                ResourceUIBean resourceUIBean = new ResourceUIBean(resource, subject);
                request.setAttribute("Resource", (Object)resource);
                request.setAttribute("ResourceId", (Object)resourceId);
                request.setAttribute("TitleParam", (Object)resource.getName());
                request.setAttribute("perfSupported", (Object)resourceUIBean.getFacets().isCallTime());
            }
        }
        catch (ResourceNotFoundException e) {
            RequestUtils.setError((HttpServletRequest)request, (String)"resource.common.error.ResourceNotFound");
        }
    }

    protected void fetchReturnPathParams(HttpServletRequest request, Map params) {
        int groupId = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"groupId", (int)-1);
        int parent = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"parent", (int)-1);
        int type = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"type", (int)-1);
        int ctype = WebUtility.getOptionalIntRequestParameter((ServletRequest)request, (String)"ctype", (int)-1);
        String[] resourceIds = request.getParameterValues("resourceIds");
        if (groupId > 0) {
            params.put("groupId", groupId);
            String category = request.getParameter("category");
            if (category == null || category.equals("")) {
                category = "COMPATIBLE";
            }
            params.put("category", category);
        } else if (parent > 0 && (type > 0 || ctype > 0)) {
            params.put("parent", parent);
            if (type > 0) {
                params.put("type", type);
            } else {
                params.put("type", ctype);
            }
        } else if (resourceIds != null && resourceIds.length > 0) {
            params.put("resourceIds", resourceIds);
        } else {
            params.put("id", WebUtility.getResourceId((ServletRequest)request));
        }
        String mode = request.getParameter("mode");
        params.put("mode", mode);
    }

    protected void setReturnPath(HttpServletRequest request, ActionMapping mapping, Map params) throws Exception {
        this.fetchReturnPathParams(request, params);
        String returnPath = ActionUtils.findReturnPath((ActionMapping)mapping, (Map)params);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("setting return path: " + returnPath));
        }
        SessionUtils.setReturnPath((HttpSession)request.getSession(), (String)returnPath);
    }

    protected void setReturnPath(HttpServletRequest request, ActionMapping mapping) throws Exception {
        this.setReturnPath(request, mapping, new HashMap());
    }

    protected void setNavMapLocation(HttpServletRequest request, ActionMapping mapping, String currLoc) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        String mode = request.getParameter("mode");
        params.put("mode", mode);
        String newUrl = ActionUtils.changeUrl((String)currLoc, params);
        request.setAttribute("currResourceMode", (Object)mode);
        request.setAttribute("currResourceType", (Object)currLoc);
        request.setAttribute("currResourceUrl", (Object)newUrl);
    }
}

