/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.condition;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.ConditionBean;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.condition.ConditionBeanConverterValidator;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

class TraitConverterValidator
implements ConditionBeanConverterValidator {
    private MeasurementDefinitionManagerLocal definitionManager = LookupUtil.getMeasurementDefinitionManager();

    public void exportProperties(Subject subject, ConditionBean fromBean, AlertCondition toCondition) {
        MeasurementDefinition definition = this.definitionManager.getMeasurementDefinition(subject, fromBean.getTraitId().intValue());
        toCondition.setMeasurementDefinition(definition);
        toCondition.setCategory(AlertConditionCategory.TRAIT);
        toCondition.setName(fromBean.getTraitName());
    }

    public void importProperties(Subject subject, AlertCondition fromCondition, ConditionBean toBean) {
        toBean.setTrigger(this.getTriggerName());
        toBean.setTraitId(Integer.valueOf(fromCondition.getMeasurementDefinition().getId()));
        toBean.setTraitName(fromCondition.getName());
    }

    public boolean validate(ConditionBean bean, ActionErrors errors, int index) {
        if (bean.getTraitId() <= 0) {
            ActionMessage err = new ActionMessage("alert.config.error.NoTraitSelected");
            errors.add("condition[" + index + "].traitStatus", err);
            return false;
        }
        return true;
    }

    public String getTriggerName() {
        return "onTrait";
    }
}

