/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.group.inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.gui.legacy.action.BaseValidatorForm;

public class GroupForm
extends BaseValidatorForm {
    private String category;
    private List<Map<String, Object>> platformTypes;
    private List<Map<String, Object>> serverTypes;
    private List<Map<String, Object>> serviceTypes;
    private List groupTypes;
    private Integer[] resourceIds;
    private String resourceTypeName;
    private Integer resourceTypeId;
    private boolean recursive;
    private String name;
    private String description;
    private String location;
    private Integer groupId;

    public Integer getCompatibleCount() {
        if (this.platformTypes == null || this.serverTypes == null || this.serviceTypes == null) {
            return new Integer(0);
        }
        return new Integer(this.platformTypes.size() + this.serverTypes.size() + this.serviceTypes.size());
    }

    public Integer getClusterCount() {
        if (this.serviceTypes == null) {
            return new Integer(0);
        }
        return new Integer(this.serviceTypes.size());
    }

    public List getPlatformTypes() {
        return this.platformTypes;
    }

    public Integer getPlatformTypeCount() {
        if (this.platformTypes == null) {
            return new Integer(0);
        }
        return new Integer(this.platformTypes.size());
    }

    public List getServerTypes() {
        return this.serverTypes;
    }

    public Integer getServerTypeCount() {
        if (this.serverTypes == null) {
            return new Integer(0);
        }
        return new Integer(this.serverTypes.size());
    }

    public List getServiceTypes() {
        return this.serviceTypes;
    }

    public Integer getServiceTypeCount() {
        if (this.serviceTypes == null) {
            return new Integer(0);
        }
        return new Integer(this.serviceTypes.size());
    }

    public void setPlatformTypes(List<ResourceType> platformTypes) {
        this.platformTypes = this.getOptionListItemsWithDashes(platformTypes);
    }

    public void setServerTypes(List<ResourceType> serverTypes) {
        this.serverTypes = this.getOptionListItemsWithDashes(serverTypes);
    }

    public void setServiceTypes(List<ResourceType> serviceTypes) {
        this.serviceTypes = this.getOptionListItemsWithDashes(serviceTypes);
    }

    private List<Map<String, Object>> getOptionListItemsWithDashes(List<ResourceType> types) {
        HashMap<String, Integer> typeNameCounts = new HashMap<String, Integer>();
        for (ResourceType type : types) {
            if (!typeNameCounts.containsKey(type.getName())) {
                typeNameCounts.put(type.getName(), 1);
                continue;
            }
            typeNameCounts.put(type.getName(), (Integer)typeNameCounts.get(type.getName()) + 1);
        }
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        if (types != null) {
            for (ResourceType type : types) {
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                map.put("value", type.getId());
                Integer count = (Integer)typeNameCounts.get(type.getName());
                map.put("label", "- " + type.getName() + (count > 1 ? " (" + type.getPlugin() + " Plugin)" : ""));
                items.add(map);
            }
        }
        return items;
    }

    public List getGroupTypes() {
        return this.groupTypes;
    }

    public void setGroupTypes(List groupTypes) {
        this.groupTypes = groupTypes;
    }

    public Integer[] getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(Integer[] resourceIds) {
        this.resourceIds = resourceIds;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = super.validate(mapping, request);
        if (this.shouldValidate(mapping, request)) {
            if (errors == null) {
                errors = new ActionErrors();
            }
            if (this.category.equals(GroupCategory.COMPATIBLE.name()) && this.resourceTypeId == null) {
                errors.add("resourceTypeId", new ActionMessage("resource.group.inventory.error.ResourceTypeId"));
            }
        }
        return errors;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public GroupCategory getGroupCategory() {
        return GroupCategory.valueOf((String)this.category);
    }

    public void setGroupCategory(GroupCategory category) {
        this.category = category.name();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getResourceTypeId() {
        return this.resourceTypeId;
    }

    public void setResourceTypeId(Integer resourceTypeId) {
        this.resourceTypeId = resourceTypeId;
    }

    public Integer getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public String getResourceTypeName() {
        return this.resourceTypeName;
    }

    public void setResourceTypeName(String resourceTypeName) {
        this.resourceTypeName = resourceTypeName;
    }

    public void loadResourceGroup(ResourceGroup group) {
        this.name = group.getName();
        this.description = group.getDescription();
        this.location = "";
        this.groupId = group.getId();
    }

    public void updateResourceGroup(ResourceGroup group) {
        if (this.name != null) {
            group.setName(this.name);
        }
        if (this.description != null) {
            group.setDescription(this.description);
        }
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }
}

