/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.taglib;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.taglibs.standard.tag.common.core.Util;

public class ConstantsTag
extends TagSupport {
    private static Log log = LogFactory.getLog((String)ConstantsTag.class.getName());
    protected static Map constants = new HashMap();
    public static final String constantsClassNameParam = "context-constants";
    private String className = null;
    private String var = null;
    private boolean varSpecified = false;
    private boolean failmode = true;
    private String symbol = null;
    private String scopeName;
    private int scope = 1;
    private boolean scopeSpecified = false;

    public void setClassname(String aClass) {
        this.className = aClass;
    }

    public String getClassname() {
        return this.className;
    }

    public void setVar(String aVar) {
        this.var = aVar;
        this.varSpecified = true;
    }

    public String getVar() {
        return this.var;
    }

    public void setFailmode(boolean theFailmode) {
        this.failmode = theFailmode;
    }

    public boolean getFailmode() {
        return this.failmode;
    }

    public void setSymbol(String aSymbol) {
        this.symbol = aSymbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setScope(String aScopeName) {
        this.scopeName = aScopeName;
        this.scope = Util.getScope((String)aScopeName);
        this.scopeSpecified = true;
    }

    public String getScope() {
        return this.scopeName;
    }

    public void release() {
        super.release();
        this.scopeName = null;
        this.var = null;
        this.symbol = null;
        this.className = null;
        this.failmode = false;
        this.scopeSpecified = false;
        this.failmode = false;
        this.scope = 1;
    }

    public int doEndTag() throws JspException {
        try {
            Map<String, String> fieldMap;
            JspWriter out = this.pageContext.getOut();
            if (this.className == null) {
                this.className = this.pageContext.getServletContext().getInitParameter(constantsClassNameParam);
            }
            if (this.validate(out)) {
                log.debug((Object)"constants tag misconfigured");
                return 6;
            }
            if (constants.containsKey(this.className)) {
                fieldMap = (Map)constants.get(this.className);
            } else {
                fieldMap = new HashMap();
                Class<?> typeClass = Class.forName(this.className);
                if (typeClass.isEnum()) {
                    for (Object enumConstantObj : typeClass.getEnumConstants()) {
                        Enum enumConstant = (Enum)enumConstantObj;
                        fieldMap.put(enumConstant.name(), enumConstant.name());
                    }
                } else {
                    Field[] fields;
                    Object instance = typeClass.newInstance();
                    for (Field field : fields = typeClass.getFields()) {
                        String fieldType = field.getType().getName();
                        String strVal = fieldType.equals("java.lang.String") ? (String)field.get(instance) : (fieldType.equals("int") ? Integer.toString(field.getInt(instance)) : (fieldType.equals("boolean") ? Boolean.toString(field.getBoolean(instance)) : (fieldType.equals("char") ? Character.toString(field.getChar(instance)) : (fieldType.equals("double") ? Double.toString(field.getDouble(instance)) : (fieldType.equals("float") ? Float.toString(field.getFloat(instance)) : (fieldType.equals("long") ? Long.toString(field.getLong(instance)) : (fieldType.equals("short") ? Short.toString(field.getShort(instance)) : (fieldType.equals("byte") ? Byte.toString(field.getByte(instance)) : field.get(instance).toString()))))))));
                        fieldMap.put(field.getName(), strVal);
                    }
                }
                constants.put(this.className, fieldMap);
            }
            if (this.symbol != null && !fieldMap.containsKey(this.symbol)) {
                String err1 = this.symbol + " was not found in " + this.className + "\n";
                String err2 = err1 + "use <constants:diag classname=\"" + this.className + "\"/>\n" + "to figure out what you're looking for";
                log.error((Object)err2);
                this.die(out, err1);
            }
            if (this.varSpecified) {
                this.doSet(fieldMap);
            } else {
                this.doOutput(fieldMap, out);
            }
        }
        catch (JspException e) {
            throw e;
        }
        catch (Exception e) {
            log.debug((Object)"doEndTag() failed: ", (Throwable)e);
            throw new JspException("Could not access constants tag", (Throwable)e);
        }
        return 6;
    }

    protected void doOutput(Map fieldMap, JspWriter out) throws IOException {
        out.print(fieldMap.get(this.symbol));
    }

    protected void doSet(Map fieldMap) {
        this.pageContext.setAttribute(this.var, fieldMap.get(this.symbol), this.scope);
    }

    protected boolean validate(JspWriter out) throws JspException {
        if (this.className == null) {
            this.die(out);
            return true;
        }
        if (this.scopeName != null && this.var == null) {
            this.die(out);
            return true;
        }
        return false;
    }

    protected void die(JspWriter out) throws JspException {
        this.die(out, "");
    }

    protected void die(JspWriter out, String err) throws JspException {
        if (this.failmode) {
            throw new JspException(err);
        }
        try {
            out.println("<!-- constants tag misconfigured -->");
        }
        catch (IOException e) {
            log.debug((Object)"constants tag misconfigured: ", (Throwable)e);
        }
    }
}

