/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.measurement.tables;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.util.MonitorUtils;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.measurement.MeasurementChartsManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.measurement.uibean.MetricDisplaySummary;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class MetricsTableUIBean {
    private final Log log = LogFactory.getLog(MetricsTableUIBean.class);
    protected MeasurementChartsManagerLocal chartManager = LookupUtil.getMeasurementChartsManager();
    protected MeasurementDefinitionManagerLocal definitionManager = LookupUtil.getMeasurementDefinitionManager();
    protected MeasurementScheduleManagerLocal scheduleManager = LookupUtil.getMeasurementScheduleManager();
    protected ResourceGroupManagerLocal resourceGroupManager = LookupUtil.getResourceGroupManager();
    public static final String MANAGED_BEAN_NAME = "MetricsTableUIBean";
    protected EntityContext context = WebUtility.getEntityContext();
    protected ResourceGroup resourceGroup;
    private List<MetricDisplaySummary> metricSummaries = null;
    private boolean valuesPresent = false;

    public EntityContext getContext() {
        return this.context;
    }

    public List<MetricDisplaySummary> getMetricSummaries() {
        int[] defIds;
        List measurementDefinitions;
        int i;
        if (null != this.metricSummaries) {
            return this.metricSummaries;
        }
        WebUser user = EnterpriseFacesContextUtility.getWebUser();
        MeasurementPreferences preferences = user.getMeasurementPreferences();
        MeasurementPreferences.MetricRangePreferences range = preferences.getMetricRangePreferences();
        if (this.context.type == EntityContext.Type.Resource) {
            List measurementSchedules = this.scheduleManager.findSchedulesForResourceAndType(user.getSubject(), this.context.resourceId, DataType.MEASUREMENT, null, true);
            int[] scheduleIds = new int[measurementSchedules.size()];
            i = 0;
            for (MeasurementSchedule sched : measurementSchedules) {
                scheduleIds[i++] = sched.getId();
            }
            this.metricSummaries = this.chartManager.getMetricDisplaySummariesForResource(user.getSubject(), this.context.resourceId, scheduleIds, range.begin.longValue(), range.end.longValue());
        } else if (this.context.type == EntityContext.Type.ResourceGroup) {
            measurementDefinitions = this.definitionManager.findMeasurementDefinitionsByResourceType(user.getSubject(), this.getResourceGroup(user).getResourceType().getId(), DataType.MEASUREMENT, null);
            defIds = new int[measurementDefinitions.size()];
            i = 0;
            for (MeasurementDefinition def : measurementDefinitions) {
                defIds[i++] = def.getId();
            }
            this.metricSummaries = this.chartManager.getMetricDisplaySummariesForCompatibleGroup(user.getSubject(), this.context.groupId, defIds, range.begin.longValue(), range.end.longValue(), true);
        } else if (this.context.type == EntityContext.Type.AutoGroup) {
            measurementDefinitions = this.definitionManager.findMeasurementDefinitionsByResourceType(user.getSubject(), this.context.getResourceTypeId(), DataType.MEASUREMENT, null);
            defIds = new int[measurementDefinitions.size()];
            i = 0;
            for (MeasurementDefinition def : measurementDefinitions) {
                defIds[i++] = def.getId();
            }
            this.metricSummaries = this.chartManager.getMetricDisplaySummariesForAutoGroup(user.getSubject(), this.context.getParentResourceId(), this.context.getResourceTypeId(), defIds, range.begin.longValue(), range.end.longValue(), true);
        } else {
            this.log.error((Object)this.context.getUnknownContextMessage());
            return new ArrayList<MetricDisplaySummary>();
        }
        for (MetricDisplaySummary summary : this.metricSummaries) {
            MonitorUtils.formatSimpleMetrics((MetricDisplaySummary)summary, (Locale)FacesContext.getCurrentInstance().getExternalContext().getRequestLocale());
            if (!summary.getValuesPresent()) continue;
            this.valuesPresent = true;
        }
        return this.metricSummaries;
    }

    public boolean isValuesPresent() {
        return this.valuesPresent;
    }

    public ResourceGroup getResourceGroup(WebUser user) {
        if (null == this.resourceGroup) {
            this.resourceGroup = this.resourceGroupManager.getResourceGroupById(user.getSubject(), this.context.groupId, GroupCategory.COMPATIBLE);
        }
        return this.resourceGroup;
    }

    public int[] getResourceGroupMemberIds(WebUser user) {
        List resources = this.resourceGroupManager.findResourcesForResourceGroup(user.getSubject(), this.context.groupId, GroupCategory.COMPATIBLE);
        int[] resourceIds = new int[resources.size()];
        int i = 0;
        for (Resource res : resources) {
            resourceIds[i] = res.getId();
            ++i;
        }
        return resourceIds;
    }
}

