/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.measurement.tables.resource;

import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.measurement.tables.MetricsTableUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;
import org.rhq.enterprise.server.measurement.uibean.MetricDisplaySummary;
import org.rhq.enterprise.server.util.LookupUtil;

public class ResourceMetricsTableUIBean
extends MetricsTableUIBean {
    private List<MetricDisplaySummary> traitSummaries;
    private List<MeasurementDataTrait> traitHistory;

    public ResourceMetricsTableUIBean() {
        HttpServletRequest request;
        int definitionId;
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        Resource resource = EnterpriseFacesContextUtility.getResource();
        WebUser user = EnterpriseFacesContextUtility.getWebUser();
        MeasurementPreferences.MetricRangePreferences range = user.getMeasurementPreferences().getMetricRangePreferences();
        List traitSchedules = this.scheduleManager.findSchedulesForResourceAndType(subject, resource.getId(), DataType.TRAIT, null, true);
        int[] traitScheduleIds = new int[traitSchedules.size()];
        int i = 0;
        for (MeasurementSchedule sched : traitSchedules) {
            traitScheduleIds[i++] = sched.getId();
        }
        if (traitScheduleIds != null) {
            this.traitSummaries = this.chartManager.getMetricDisplaySummariesForResource(subject, resource.getId(), traitScheduleIds, range.begin.longValue(), range.end.longValue());
        }
        if ((definitionId = WebUtility.getOptionalIntRequestParameter((ServletRequest)(request = FacesContextUtility.getRequest()), (String)"traitDefinitionId", (int)-1)) != -1) {
            MeasurementDataManagerLocal dataManager = LookupUtil.getMeasurementDataManager();
            this.traitHistory = dataManager.findTraits(subject, resource.getId(), definitionId);
        }
    }

    public List<MetricDisplaySummary> getTraitSummaries() {
        return this.traitSummaries;
    }

    public List<MeasurementDataTrait> getTraitHistory() {
        return this.traitHistory;
    }
}

