/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.navigation.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.resource.group.composite.AutoGroupComposite;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.navigation.contextmenu.MenuItemDescriptor;
import org.rhq.enterprise.gui.navigation.contextmenu.MetricMenuItemDescriptor;
import org.rhq.enterprise.gui.navigation.contextmenu.QuickLinksDescriptor;
import org.rhq.enterprise.gui.navigation.contextmenu.TreeContextMenuBase;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class AutoGroupTreeContextMenuUIBean
extends TreeContextMenuBase {
    private AutoGroupComposite currentAutoGroup;
    private List<MenuItemDescriptor> metricMenuItemDescriptorsForView;
    private List<MetricMenuItemDescriptor> metricMenuItemDescriptorsForGraph;
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
    private MeasurementDefinitionManagerLocal measurementDefinitionManager = LookupUtil.getMeasurementDefinitionManager();

    protected void init() throws Exception {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String parentIdString = FacesContextUtility.getOptionalRequestParameter((String)"contextParentResourceId");
        String resourceTypeIdString = FacesContextUtility.getOptionalRequestParameter((String)"contextAutoGroupResourceTypeId");
        if (parentIdString != null && resourceTypeIdString != null) {
            int parentId = Integer.parseInt(parentIdString);
            int resourceTypeId = Integer.parseInt(resourceTypeIdString);
            this.currentAutoGroup = this.getAutoGroupForResourceType(subject, parentId, resourceTypeId);
            List definitions = this.measurementDefinitionManager.findMeasurementDefinitionsByResourceType(subject, resourceTypeId, DataType.MEASUREMENT, null);
            this.metricMenuItemDescriptorsForView = this.createViewMenuItemDescriptors(this.currentAutoGroup, definitions);
            this.metricMenuItemDescriptorsForGraph = this.createGraphMenuItemDescriptors(this.currentAutoGroup, definitions);
        } else {
            this.currentAutoGroup = null;
            this.metricMenuItemDescriptorsForView = null;
            this.metricMenuItemDescriptorsForGraph = null;
        }
    }

    protected List<String> getMenuHeaders() {
        String name = this.currentAutoGroup.getResourceType().getName();
        return Collections.singletonList(name + " (" + this.currentAutoGroup.getMemberCount() + ")");
    }

    protected QuickLinksDescriptor getMenuQuickLinks() {
        int parentId = this.currentAutoGroup.getParentResource().getId();
        int resourceTypeId = this.currentAutoGroup.getResourceType().getId();
        QuickLinksDescriptor descriptor = new QuickLinksDescriptor();
        descriptor.setMenuItemId("menu_ag_" + parentId + "_" + resourceTypeId);
        descriptor.setMonitoringUrl("/rhq/autogroup/monitor/graphs.xhtml?parent=" + parentId + "&type=" + resourceTypeId);
        descriptor.setEventUrl("/rhq/autogroup/events/history.xhtml?parent=" + parentId + "&type=" + resourceTypeId);
        return descriptor;
    }

    protected List<MenuItemDescriptor> getViewChartsMenuItems() {
        return this.metricMenuItemDescriptorsForView;
    }

    protected List<MetricMenuItemDescriptor> getGraphToViewMenuItems() {
        return this.metricMenuItemDescriptorsForGraph;
    }

    protected List<MenuItemDescriptor> getOperationsMenuItems() {
        return null;
    }

    protected int getResourceTypeId() {
        return this.currentAutoGroup.getResourceType().getId();
    }

    protected boolean shouldCreateMenu() {
        return this.currentAutoGroup != null;
    }

    private AutoGroupComposite getAutoGroupForResourceType(Subject subject, int parentId, int resourceTypeId) {
        List autogroups = this.resourceManager.findChildrenAutoGroups(subject, parentId, new int[]{resourceTypeId});
        for (AutoGroupComposite autogroup : autogroups) {
            if (autogroup.getResourceType() == null) continue;
            return autogroup;
        }
        return null;
    }

    private List<MetricMenuItemDescriptor> createGraphMenuItemDescriptors(AutoGroupComposite autoGroup, List<MeasurementDefinition> definitions) {
        ArrayList<MetricMenuItemDescriptor> ret = new ArrayList<MetricMenuItemDescriptor>();
        int parentId = autoGroup.getParentResource().getId();
        int resourceTypeId = autoGroup.getResourceType().getId();
        for (MeasurementDefinition definition : definitions) {
            MetricMenuItemDescriptor descriptor = new MetricMenuItemDescriptor();
            this.fillBasicMetricMenuItemDescriptor((MenuItemDescriptor)descriptor, parentId, resourceTypeId, "measurementGraphMenuItem_ag_", definition);
            descriptor.setMetricToken("ag," + parentId + "," + definition.getId() + "," + resourceTypeId);
            ret.add(descriptor);
        }
        return ret;
    }

    private List<MenuItemDescriptor> createViewMenuItemDescriptors(AutoGroupComposite autoGroup, List<MeasurementDefinition> definitions) {
        ArrayList<MenuItemDescriptor> ret = new ArrayList<MenuItemDescriptor>();
        int parentId = autoGroup.getParentResource().getId();
        int resourceTypeId = autoGroup.getResourceType().getId();
        for (MeasurementDefinition definition : definitions) {
            MenuItemDescriptor descriptor = new MenuItemDescriptor();
            this.fillBasicMetricMenuItemDescriptor(descriptor, parentId, resourceTypeId, "measurementChartMenuItem_ag_", definition);
            ret.add(descriptor);
        }
        return ret;
    }

    private void fillBasicMetricMenuItemDescriptor(MenuItemDescriptor descriptor, int parentId, int resourceTypeId, String idPrefix, MeasurementDefinition definition) {
        descriptor.setMenuItemId(idPrefix + definition.getId());
        descriptor.setName(definition.getDisplayName());
        String url = "/resource/common/monitor/Visibility.do";
        url = url + "?mode=chartSingleMetricMultiResource";
        url = url + "&m=" + definition.getId();
        url = url + "&type=" + resourceTypeId;
        url = url + "&parent=" + parentId;
        descriptor.setUrl(url);
    }
}

