/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.navigation.resource;

import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.composite.ResourceWithAvailability;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.navigation.contextmenu.MenuItemDescriptor;
import org.rhq.enterprise.gui.navigation.contextmenu.MetricMenuItemDescriptor;
import org.rhq.enterprise.gui.navigation.contextmenu.QuickLinksDescriptor;
import org.rhq.enterprise.gui.navigation.contextmenu.TreeContextMenuBase;
import org.rhq.enterprise.gui.navigation.resource.ResourceTreeNode;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.richfaces.component.UITree;
import org.richfaces.event.NodeSelectedEvent;

public class ResourceTreeContextMenuUIBean
extends TreeContextMenuBase {
    private OperationManagerLocal operationManager = LookupUtil.getOperationManager();
    private MeasurementScheduleManagerLocal measurementScheduleManager = LookupUtil.getMeasurementScheduleManager();
    private ResourceManagerLocal resourceManager = LookupUtil.getResourceManager();
    private Resource currentResource;
    private List<MenuItemDescriptor> menuItemDescriptorsForView;
    private List<MetricMenuItemDescriptor> metricMenuItemDescriptorsForGraph;
    private List<MenuItemDescriptor> menuItemDescriptorsForOperations;

    protected void init() throws Exception {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String resourceIdString = FacesContextUtility.getOptionalRequestParameter((String)"contextResourceId");
        if (resourceIdString != null) {
            int resourceId = Integer.parseInt(resourceIdString);
            this.currentResource = this.resourceManager.getResourceById(subject, resourceId);
            List schedules = this.measurementScheduleManager.findSchedulesForResourceAndType(subject, resourceId, DataType.MEASUREMENT, null, true);
            List operations = this.operationManager.findSupportedResourceTypeOperations(subject, this.currentResource.getResourceType().getId(), false);
            this.menuItemDescriptorsForView = this.createViewMenuItemDescriptors(resourceId, schedules);
            this.metricMenuItemDescriptorsForGraph = this.createGraphMenuItemDescriptors(resourceId, schedules);
            this.menuItemDescriptorsForOperations = this.createOperationMenuItemDescriptors(resourceId, operations);
        } else {
            this.currentResource = null;
            this.menuItemDescriptorsForView = null;
            this.metricMenuItemDescriptorsForGraph = null;
            this.menuItemDescriptorsForOperations = null;
        }
    }

    protected List<String> getMenuHeaders() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(this.currentResource.getName());
        ret.add(this.currentResource.getResourceType().getName());
        return ret;
    }

    protected QuickLinksDescriptor getMenuQuickLinks() {
        int resourceId = this.currentResource.getId();
        QuickLinksDescriptor descriptor = new QuickLinksDescriptor();
        descriptor.setMenuItemId("menu_res_" + resourceId);
        descriptor.setMonitoringUrl("/rhq/resource/monitor/graphs.xhtml?id=" + resourceId);
        descriptor.setInventoryUrl("/rhq/resource/inventory/view.xhtml?id=" + resourceId);
        descriptor.setAlertsUrl("/rhq/resource/alert/listAlertDefinitions.xhtml?id=" + resourceId);
        descriptor.setConfigurationUrl("/rhq/resource/configuration/view.xhtml?id=" + resourceId);
        descriptor.setOperationUrl("/rhq/resource/operation/resourceOperationScheduleNew.xhtml?id=" + resourceId);
        descriptor.setEventUrl("/rhq/resource/events/history.xhtml?id=" + resourceId);
        descriptor.setContentUrl("/rhq/resource/content/view.xhtml?id=" + resourceId);
        return descriptor;
    }

    protected List<MenuItemDescriptor> getViewChartsMenuItems() {
        return this.menuItemDescriptorsForView;
    }

    protected List<MetricMenuItemDescriptor> getGraphToViewMenuItems() {
        return this.metricMenuItemDescriptorsForGraph;
    }

    protected List<MenuItemDescriptor> getOperationsMenuItems() {
        return this.menuItemDescriptorsForOperations;
    }

    protected int getResourceTypeId() {
        return this.currentResource.getResourceType().getId();
    }

    protected boolean shouldCreateMenu() {
        return this.currentResource != null;
    }

    private List<MetricMenuItemDescriptor> createGraphMenuItemDescriptors(int resourceId, List<MeasurementSchedule> schedules) {
        ArrayList<MetricMenuItemDescriptor> ret = new ArrayList<MetricMenuItemDescriptor>();
        for (MeasurementSchedule schedule : schedules) {
            MetricMenuItemDescriptor descriptor = new MetricMenuItemDescriptor();
            this.fillBasicMetricMenuItemDescriptor((MenuItemDescriptor)descriptor, resourceId, "measurementGraphMenuItem_", schedule);
            descriptor.setMetricToken(resourceId + "," + schedule.getId());
            ret.add(descriptor);
        }
        return ret;
    }

    private List<MenuItemDescriptor> createViewMenuItemDescriptors(int resourceId, List<MeasurementSchedule> schedules) {
        ArrayList<MenuItemDescriptor> ret = new ArrayList<MenuItemDescriptor>();
        for (MeasurementSchedule schedule : schedules) {
            MenuItemDescriptor descriptor = new MenuItemDescriptor();
            this.fillBasicMetricMenuItemDescriptor(descriptor, resourceId, "measurementChartMenuItem_", schedule);
            ret.add(descriptor);
        }
        return ret;
    }

    private List<MenuItemDescriptor> createOperationMenuItemDescriptors(int resourceId, List<OperationDefinition> operations) {
        ArrayList<MenuItemDescriptor> ret = new ArrayList<MenuItemDescriptor>();
        for (OperationDefinition def : operations) {
            MenuItemDescriptor descriptor = new MenuItemDescriptor();
            descriptor.setMenuItemId("operation_" + def.getId());
            descriptor.setName(def.getDisplayName());
            String url = "/rhq/resource/operation/resourceOperationScheduleNew.xhtml";
            url = url + "?id=" + resourceId;
            url = url + "&opId=" + def.getId();
            descriptor.setUrl(url);
            ret.add(descriptor);
        }
        return ret;
    }

    private void fillBasicMetricMenuItemDescriptor(MenuItemDescriptor descriptor, int resourceId, String idPrefix, MeasurementSchedule schedule) {
        descriptor.setMenuItemId(idPrefix + schedule.getId());
        descriptor.setName(schedule.getDefinition().getDisplayName());
        String url = "/resource/common/monitor/Visibility.do";
        url = url + "?mode=chartSingleMetricSingleResource";
        url = url + "&m=" + schedule.getDefinition().getId();
        url = url + "&id=" + resourceId;
        descriptor.setUrl(url);
    }

    public void processSelection(NodeSelectedEvent event) {
        UITree tree = (UITree)event.getComponent();
        try {
            Object node = tree.getRowData();
            ResourceTreeNode selectedNode = (ResourceTreeNode)node;
            Object data = selectedNode.getData();
            if (data instanceof ResourceWithAvailability) {
                FacesContext.getCurrentInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

