/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.navigation.resource;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.rhq.core.domain.resource.composite.ResourceFacets;
import org.rhq.core.domain.resource.flyweight.AutoGroupCompositeFlyweight;
import org.rhq.core.domain.resource.flyweight.ResourceFlyweight;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.tag.FunctionTagLibrary;
import org.rhq.enterprise.gui.navigation.resource.ResourceTreeNode;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.richfaces.component.UITree;
import org.richfaces.component.html.HtmlTree;
import org.richfaces.component.state.TreeState;
import org.richfaces.component.state.TreeStateAdvisor;
import org.richfaces.event.NodeExpandedEvent;
import org.richfaces.event.NodeSelectedEvent;
import org.richfaces.model.TreeRowKey;

public class ResourceTreeStateAdvisor
implements TreeStateAdvisor {
    private ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
    Set<ResourceTreeNode> openNodes = new HashSet();

    public void changeExpandListener(NodeExpandedEvent e) {
        HtmlTree tree = (HtmlTree)e.getComponent();
        TreeState state = (TreeState)tree.getComponentState();
        if (state.getSelectedNode() != null) {
            boolean closingParent = false;
            TreeRowKey key = (TreeRowKey)tree.getRowKey();
            ResourceTreeNode node = (ResourceTreeNode)tree.getRowData((Object)key);
            ResourceTreeNode selectedNode = (ResourceTreeNode)tree.getRowData((Object)state.getSelectedNode());
            for (ResourceTreeNode traverseCheckNode = selectedNode.getParent(); traverseCheckNode != null; traverseCheckNode = traverseCheckNode.getParent()) {
                if (!node.equals((Object)traverseCheckNode)) continue;
                closingParent = true;
                break;
            }
            if (closingParent) {
                if (this.redirectTo(node)) {
                    state.setSelected(key);
                    this.openNodes.remove(node);
                    tree.setBypassUpdates(true);
                } else if (!this.redirectTo(selectedNode)) {
                    FacesContext.getCurrentInstance().addMessage("leftNavTreeForm:leftNavTree", new FacesMessage(FacesMessage.SEVERITY_WARN, "Failed to re-expand node that shouldn't be collapsed.", null));
                }
            } else if (this.openNodes.contains(node)) {
                this.openNodes.remove(node);
            } else {
                this.openNodes.add(node);
            }
        }
    }

    public void nodeSelectListener(NodeSelectedEvent e) {
        HtmlTree tree = (HtmlTree)e.getComponent();
        TreeState state = (TreeState)tree.getComponentState();
        ResourceTreeNode node = (ResourceTreeNode)tree.getRowData(tree.getRowKey());
        if (node != null && !this.redirectTo(node)) {
            state.setSelected(e.getOldSelection());
        }
    }

    public Boolean adviseNodeOpened(UITree tree) {
        boolean setOpenStates;
        String id;
        int selecteAGTypeId;
        TreeRowKey key = (TreeRowKey)tree.getRowKey();
        if (key == null) {
            return null;
        }
        ResourceTreeNode node = (ResourceTreeNode)tree.getRowData((Object)key);
        if (node.getParent() == null) {
            return true;
        }
        int selectedId = 0;
        String typeId = FacesContextUtility.getOptionalRequestParameter((String)"type");
        int n = selecteAGTypeId = typeId == null || typeId.length() == 0 ? 0 : Integer.parseInt(typeId);
        if (typeId != null) {
            id = FacesContextUtility.getOptionalRequestParameter((String)"parent");
            if (id != null && id.length() != 0) {
                selectedId = Integer.parseInt(id);
            }
        } else {
            id = FacesContextUtility.getOptionalRequestParameter((String)"id");
            if (id != null && id.length() != 0) {
                selectedId = Integer.parseInt(id);
            }
        }
        boolean bl = setOpenStates = !tree.isBypassUpdates();
        if (this.preopen(node, selectedId, selecteAGTypeId, setOpenStates)) {
            return true;
        }
        return this.openNodes.contains(node);
    }

    private boolean preopen(ResourceTreeNode resourceTreeNode, int selectedResourceId, int selectedAGTypeId, boolean setOpenStates) {
        boolean ret = false;
        for (ResourceTreeNode child : resourceTreeNode.getChildren()) {
            AutoGroupCompositeFlyweight ag;
            if (child.getData() instanceof ResourceFlyweight && selectedAGTypeId == 0) {
                if (((ResourceFlyweight)child.getData()).getId() == selectedResourceId) {
                    ret = true;
                    break;
                }
            } else if (child.getData() instanceof AutoGroupCompositeFlyweight && (ag = (AutoGroupCompositeFlyweight)child.getData()).getParentResource().getId() == selectedResourceId && ag.getResourceType() != null && ag.getResourceType().getId() == selectedAGTypeId) {
                ret = true;
                break;
            }
            if (!this.preopen(child, selectedResourceId, selectedAGTypeId, setOpenStates)) continue;
            ret = true;
            break;
        }
        if (setOpenStates && ret) {
            this.openNodes.add(resourceTreeNode);
        }
        return ret;
    }

    public Boolean adviseNodeSelected(UITree tree) {
        TreeState state = (TreeState)((HtmlTree)tree).getComponentState();
        String id = FacesContextUtility.getOptionalRequestParameter((String)"id");
        String parent = FacesContextUtility.getOptionalRequestParameter((String)"parent");
        String type = FacesContextUtility.getOptionalRequestParameter((String)"type");
        ResourceTreeNode node = (ResourceTreeNode)tree.getRowData(tree.getRowKey());
        if (node.getData() instanceof AutoGroupCompositeFlyweight) {
            AutoGroupCompositeFlyweight ag = (AutoGroupCompositeFlyweight)node.getData();
            if (ag.getParentResource() != null && ag.getResourceType() != null && String.valueOf(ag.getParentResource().getId()).equals(parent) && String.valueOf(ag.getResourceType().getId()).equals(type)) {
                return true;
            }
        } else if (node.getData() instanceof ResourceFlyweight && String.valueOf(((ResourceFlyweight)node.getData()).getId()).equals(id)) {
            return Boolean.TRUE;
        }
        return tree.getRowKey().equals(state.getSelectedNode());
    }

    public boolean getHasMessages() {
        return FacesContext.getCurrentInstance().getMessages("leftNavTreeForm:leftNavTree").hasNext();
    }

    private boolean redirectTo(ResourceTreeNode node) {
        HttpServletResponse response = (HttpServletResponse)FacesContextUtility.getFacesContext().getExternalContext().getResponse();
        String path = "";
        if (node.getData() instanceof ResourceFlyweight) {
            ResourceFlyweight flyweight = (ResourceFlyweight)node.getData();
            if (flyweight.isLocked()) {
                FacesContext.getCurrentInstance().addMessage("leftNavTreeForm:leftNavTree", new FacesMessage(FacesMessage.SEVERITY_WARN, "You have not been granted view access to this resource", null));
                return false;
            }
            path = FacesContextUtility.getRequest().getRequestURI();
            ResourceFacets facets = this.resourceTypeManager.getResourceFacets(flyweight.getResourceType().getId());
            String fallbackPath = FunctionTagLibrary.getDefaultResourceTabURL();
            if (!path.startsWith("/rhq/resource")) {
                path = fallbackPath;
            } else if (path.startsWith("/rhq/resource/configuration/") && !facets.isConfiguration() || path.startsWith("/rhq/resource/content/") && !facets.isContent() || path.startsWith("/rhq/resource/operation") && !facets.isOperation() || path.startsWith("/rhq/resource/events") && !facets.isEvent()) {
                path = fallbackPath;
            } else if (path.startsWith("/rhq/resource/configuration/view-map.xhtml") || path.startsWith("/rhq/resource/configuration/edit-map.xhtml") || path.startsWith("/rhq/resource/configuration/add-map.xhtml") || path.startsWith("/rhq/resource/configuration/edit.xhtml") && facets.isConfiguration()) {
                path = "/rhq/resource/configuration/view.xhtml";
            } else if (!path.startsWith("/rhq/resource/content/view.xhtml") && path.startsWith("/rhq/resource/content/") && facets.isContent()) {
                path = "/rhq/resource/content/view.xhtml";
            } else if (!(!path.startsWith("/rhq/resource/inventory/") || path.startsWith("/rhq/resource/inventory/view.xhtml") || facets.isPluginConfiguration() && path.startsWith("/rhq/resource/inventory/view-connection.xhtml") || path.startsWith("/rhq/resource/inventory/view-agent.xhtml"))) {
                path = "/rhq/resource/inventory/view.xhtml";
            } else if (path.startsWith("/rhq/resource/operation/resourceOperationHistoryDetails.xhtml")) {
                path = "/rhq/resource/operation/resourceOperationHistory.xhtml";
            } else if (path.startsWith("/rhq/resource/operation/resourceOperationScheduleDetails.xhtml")) {
                path = "/rhq/resource/operation/resourceOperationSchedules.xhtml";
            } else if (path.startsWith("/rhq/resource/monitor/response.xhtml") && !facets.isCallTime()) {
                path = fallbackPath;
            }
            path = path + "?id=" + flyweight.getId();
        } else if (node.getData() instanceof AutoGroupCompositeFlyweight) {
            AutoGroupCompositeFlyweight ag = (AutoGroupCompositeFlyweight)node.getData();
            if (ag.getResourceType() == null) {
                FacesContext.getCurrentInstance().addMessage("leftNavTreeForm:leftNavTree", new FacesMessage(FacesMessage.SEVERITY_WARN, "No subcategory page exists.", null));
                return false;
            }
            if (ag.getMemberCount() != (long)node.getChildren().size()) {
                FacesContext.getCurrentInstance().addMessage("leftNavTreeForm:leftNavTree", new FacesMessage(FacesMessage.SEVERITY_WARN, "You must have view access to all resources in an autogroup to view it", null));
                return false;
            }
            path = "/rhq/autogroup/monitor/graphs.xhtml?parent=" + ag.getParentResource().getId() + "&type=" + ag.getResourceType().getId();
        }
        try {
            response.sendRedirect(path);
            return true;
        }
        catch (IOException ioe) {
            FacesContext.getCurrentInstance().addMessage("leftNavTreeForm:leftNavTree", new FacesMessage(FacesMessage.SEVERITY_WARN, "Unable to browse to selected resource view: " + ioe.getMessage(), null));
            return false;
        }
    }
}

