/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.operation.definition.group;

import java.util.Collection;
import java.util.List;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.composite.IntegerOptionItem;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.gui.operation.definition.OperationDefinitionUIBean;
import org.rhq.enterprise.gui.operation.definition.group.ResourceGroupExecutionTypeUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;

public class ResourceGroupOperationDefinitionUIBean
extends OperationDefinitionUIBean {
    private String resourceExecutionOption = ResourceGroupExecutionTypeUIBean.Type.CONCURRENT.name();
    private List<IntegerOptionItem> resourceNameItems;
    private boolean haltOnFailure = false;

    public ResourceGroupOperationDefinitionUIBean() {
        ResourceGroup resourceGroup = EnterpriseFacesContextUtility.getResourceGroup();
        this.resourceNameItems = this.operationManager.getResourceNameOptionItems(resourceGroup.getId());
    }

    protected String getBeanName() {
        return "ResourceGroupOperationDefinitionUIBean";
    }

    public PageList<OperationDefinition> getOperationDefinitions() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        ResourceGroup resourceGroup = EnterpriseFacesContextUtility.getResourceGroup();
        List definitions = this.operationManager.findSupportedGroupOperations(subject, resourceGroup.getId(), false);
        return new PageList((Collection)definitions, new PageControl(0, definitions.size()));
    }

    public List<IntegerOptionItem> getResourceNameItems() {
        return this.resourceNameItems;
    }

    public void setResourceNameItems(List<IntegerOptionItem> names) {
        this.resourceNameItems = names;
    }

    public String getResourceExecutionOption() {
        return this.resourceExecutionOption;
    }

    public void setResourceExecutionOption(String resourceExecutionOption) {
        this.resourceExecutionOption = resourceExecutionOption;
    }

    public boolean isConcurrent() {
        return ResourceGroupExecutionTypeUIBean.Type.CONCURRENT.name().equals(this.resourceExecutionOption);
    }

    public boolean getHaltOnFailure() {
        return this.isHaltOnFailure();
    }

    public boolean isHaltOnFailure() {
        return this.haltOnFailure;
    }

    public void setHaltOnFailure(boolean haltOnFailure) {
        this.haltOnFailure = haltOnFailure;
    }
}

