/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.operation.schedule.group;

import java.util.ArrayList;
import java.util.List;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.composite.IntegerOptionItem;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.gui.operation.definition.group.ResourceGroupExecutionTypeUIBean;
import org.rhq.enterprise.gui.operation.schedule.OperationScheduleDetailsUIBean;
import org.rhq.enterprise.server.operation.GroupOperationSchedule;
import org.rhq.enterprise.server.operation.OperationSchedule;

public class ResourceGroupOperationScheduleDetailsUIBean
extends OperationScheduleDetailsUIBean {
    private String resourceExecutionOption;
    private List<IntegerOptionItem> resourceNameItems;
    private GroupOperationSchedule groupSchedule;

    public OperationSchedule getOperationSchedule(Subject subject, String jobId) throws Exception {
        return this.manager.getGroupOperationSchedule(subject, jobId);
    }

    protected void init() {
        if (null == this.schedule) {
            super.init();
            this.resourceExecutionOption = this.getResourceExecutionOption((GroupOperationSchedule)this.schedule);
            this.resourceNameItems = this.getResourceNameItems((GroupOperationSchedule)this.schedule);
        }
    }

    private String getResourceExecutionOption(GroupOperationSchedule schedule) {
        boolean isOrdered;
        List order = schedule.getExecutionOrder();
        boolean bl = isOrdered = order != null && order.size() > 0;
        if (isOrdered) {
            return ResourceGroupExecutionTypeUIBean.Type.ORDERED.name();
        }
        return ResourceGroupExecutionTypeUIBean.Type.CONCURRENT.name();
    }

    private List<IntegerOptionItem> getResourceNameItems(GroupOperationSchedule schedule) {
        List resourceOrder = schedule.getExecutionOrder();
        if (resourceOrder == null) {
            return new ArrayList<IntegerOptionItem>();
        }
        ArrayList<IntegerOptionItem> results = new ArrayList<IntegerOptionItem>();
        for (Resource next : resourceOrder) {
            results.add(new IntegerOptionItem(Integer.valueOf(next.getId()), next.getName()));
        }
        return results;
    }

    public String getResourceExecutionOption() {
        this.init();
        return this.resourceExecutionOption;
    }

    public List<IntegerOptionItem> getResourceNameItems() {
        this.init();
        return this.resourceNameItems;
    }

    public void setResourceExecutionOption(String resourceExecutionOption) {
        this.resourceExecutionOption = resourceExecutionOption;
    }

    public void setResourceNameItems(List<IntegerOptionItem> resourceNameItems) {
        this.resourceNameItems = resourceNameItems;
    }

    public GroupOperationSchedule getGroupSchedule() {
        if (this.groupSchedule == null) {
            this.groupSchedule = (GroupOperationSchedule)this.schedule;
        }
        return this.groupSchedule;
    }
}

