/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.rt;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.rhq.enterprise.gui.image.data.IStackedDataPoint;
import org.rhq.enterprise.gui.rt.Segment;

public class SegmentInfo
implements Serializable,
IStackedDataPoint {
    private Segment[] segments = new Segment[3];
    private double total;
    private String chartLabel = null;
    private long timestamp;

    public SegmentInfo(String label) {
        this.chartLabel = label;
    }

    public void addSegment(int index, Segment s) {
        if (this.segments[index] != null && !Double.isNaN(this.segments[index].getValue())) {
            this.total -= this.segments[index].getValue();
        }
        this.segments[index] = s;
        if (!Double.isNaN(this.segments[index].getValue())) {
            this.total += this.segments[index].getValue();
        }
    }

    public Segment getSegment(int index) {
        return this.segments[index];
    }

    public List getSegments() {
        return Arrays.asList(this.segments);
    }

    public boolean removeSegment(Segment s) {
        for (int i = 0; i < 3; ++i) {
            if (!this.segments[i].equals(s)) continue;
            this.segments[i] = null;
            return true;
        }
        return false;
    }

    public double getTotal() {
        return this.total;
    }

    public void setTotal(double d) {
        this.total = d;
    }

    public double getValue() {
        for (int i = 0; i < 3; ++i) {
            if (this.segments[i] == null || Double.isNaN(this.segments[i].getValue())) continue;
            return this.segments[i].getValue();
        }
        return Double.NaN;
    }

    public double[] getValues() {
        double[] values = new double[3];
        for (int i = 0; i < 3; ++i) {
            if (this.segments[i] == null) continue;
            values[i] = this.segments[i].getValue();
        }
        return values;
    }

    public void setLabel(String label) {
        this.chartLabel = label;
    }

    public String getLabel() {
        return this.chartLabel;
    }

    public void setTimestamp(long time) {
        this.timestamp = time;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("{");
        s.append("total=").append(this.total);
        s.append(" segments=[").append(this.segments[0]);
        s.append(",").append(this.segments[1]);
        s.append(",").append(this.segments[2]).append("]");
        return s.append("}").toString();
    }
}

