/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.subsystem;

import java.util.ArrayList;
import java.util.Date;
import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import javax.faces.model.SelectItem;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.composite.AlertDefinitionComposite;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.util.IntExtractor;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.gui.common.converter.SelectItemUtils;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.subsystem.SubsystemAlertDefinitionUIBean;
import org.rhq.enterprise.gui.subsystem.SubsystemView;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertTemplateManagerLocal;
import org.rhq.enterprise.server.alert.GroupAlertDefinitionManagerLocal;
import org.rhq.enterprise.server.subsystem.AlertSubsystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class SubsystemAlertDefinitionUIBean
extends SubsystemView {
    public static final String MANAGED_BEAN_NAME = "SubsystemAlertDefinitionUIBean";
    private static final String FORM_PREFIX = "alertDefinitionSubsystemForm:";
    private final String CALENDAR_SUFFIX = "InputDate";
    private AlertSubsystemManagerLocal manager = LookupUtil.getAlertSubsystemManager();
    private AlertDefinitionManagerLocal alertDefinitionManager = LookupUtil.getAlertDefinitionManager();
    private GroupAlertDefinitionManagerLocal groupAlertDefinitionManager = LookupUtil.getGroupAlertDefinitionManager();
    private AlertTemplateManagerLocal alertTemplateManager = LookupUtil.getAlertTemplateManager();
    private static String datePattern;
    private String resourceFilter;
    private String parentFilter;
    private Date dateBeginFilter;
    private Date dateEndFilter;
    private String categoryFilter;
    private SelectItem[] categoryFilterItems;
    private IntExtractor<AlertDefinitionComposite> RESOURCE_ID_EXTRACTOR = new /* Unavailable Anonymous Inner Class!! */;

    public SubsystemAlertDefinitionUIBean() {
        datePattern = EnterpriseFacesContextUtility.getWebUser().getWebPreferences().getDateTimeDisplayPreferences().getDateTimeFormatTrigger();
        this.categoryFilterItems = SelectItemUtils.convertFromEnum(AlertConditionCategory.class, (boolean)true);
        this.categoryFilter = (String)this.categoryFilterItems[0].getValue();
    }

    public String getDatePattern() {
        return datePattern;
    }

    public String getResourceFilter() {
        return this.resourceFilter;
    }

    public void setResourceFilter(String resourceFilter) {
        this.resourceFilter = resourceFilter;
    }

    public String getParentFilter() {
        return this.parentFilter;
    }

    public void setParentFilter(String parentFilter) {
        this.parentFilter = parentFilter;
    }

    public Date getDateBeginFilter() {
        return this.dateBeginFilter;
    }

    public void setDateBeginFilter(Date dateSubmittedFilter) {
        this.dateBeginFilter = dateSubmittedFilter;
    }

    public Date getDateEndFilter() {
        return this.dateEndFilter;
    }

    public void setDateEndFilter(Date dateCompletedFilter) {
        this.dateEndFilter = dateCompletedFilter;
    }

    public String getCategoryFilter() {
        return this.categoryFilter;
    }

    public void setCategoryFilter(String statusFilter) {
        this.categoryFilter = statusFilter;
    }

    public SelectItem[] getCategoryFilterItems() {
        return this.categoryFilterItems;
    }

    public void setCategoryFilterItems(SelectItem[] statusFilterItems) {
        this.categoryFilterItems = statusFilterItems;
    }

    public String deleteSelected() {
        Integer[] selected = this.getSelectedItems();
        try {
            Subject subject = this.getSubject();
            ArrayList<Integer> resourceDefinitions = new ArrayList<Integer>();
            ArrayList<Integer> groupDefinitions = new ArrayList<Integer>();
            ArrayList<Integer> typeDefinitions = new ArrayList<Integer>();
            for (Integer definitionId : selected) {
                if (this.alertDefinitionManager.isTemplate(definitionId)) {
                    typeDefinitions.add(definitionId);
                    continue;
                }
                if (this.alertDefinitionManager.isGroupAlertDefinition(definitionId)) {
                    groupDefinitions.add(definitionId);
                    continue;
                }
                resourceDefinitions.add(definitionId);
            }
            this.alertDefinitionManager.removeAlertDefinitions(subject, ArrayUtils.unwrapCollection(resourceDefinitions));
            this.groupAlertDefinitionManager.removeGroupAlertDefinitions(subject, groupDefinitions.toArray(new Integer[groupDefinitions.size()]));
            this.alertTemplateManager.removeAlertTemplates(subject, typeDefinitions.toArray(new Integer[typeDefinitions.size()]));
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Deleted selected alert definitions.");
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete selected alert definitions.", (Throwable)e);
        }
        return "success";
    }

    public String disableSelected() {
        Integer[] selected = this.getSelectedItems();
        try {
            Subject subject = this.getSubject();
            ArrayList<Integer> resourceDefinitions = new ArrayList<Integer>();
            ArrayList<Integer> groupDefinitions = new ArrayList<Integer>();
            ArrayList<Integer> typeDefinitions = new ArrayList<Integer>();
            for (Integer definitionId : selected) {
                if (this.alertDefinitionManager.isTemplate(definitionId)) {
                    typeDefinitions.add(definitionId);
                    continue;
                }
                if (this.alertDefinitionManager.isGroupAlertDefinition(definitionId)) {
                    groupDefinitions.add(definitionId);
                    continue;
                }
                resourceDefinitions.add(definitionId);
            }
            this.alertDefinitionManager.disableAlertDefinitions(subject, ArrayUtils.unwrapCollection(resourceDefinitions));
            this.groupAlertDefinitionManager.disableGroupAlertDefinitions(subject, groupDefinitions.toArray(new Integer[groupDefinitions.size()]));
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Disable selected alert definitions.");
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to disable selected alert definitions.", (Throwable)e);
        }
        return "success";
    }

    public String enableSelected() {
        Integer[] selected = this.getSelectedItems();
        try {
            Subject subject = this.getSubject();
            ArrayList<Integer> resourceDefinitions = new ArrayList<Integer>();
            ArrayList<Integer> groupDefinitions = new ArrayList<Integer>();
            ArrayList<Integer> typeDefinitions = new ArrayList<Integer>();
            for (Integer definitionId : selected) {
                if (this.alertDefinitionManager.isTemplate(definitionId)) {
                    typeDefinitions.add(definitionId);
                    continue;
                }
                if (this.alertDefinitionManager.isGroupAlertDefinition(definitionId)) {
                    groupDefinitions.add(definitionId);
                    continue;
                }
                resourceDefinitions.add(definitionId);
            }
            this.alertDefinitionManager.enableAlertDefinitions(subject, ArrayUtils.unwrapCollection(resourceDefinitions));
            this.groupAlertDefinitionManager.enableGroupAlertDefinitions(subject, groupDefinitions.toArray(new Integer[groupDefinitions.size()]));
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Enable selected alert definitions.");
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to enable selected alert definitions.", (Throwable)e);
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ResultsDataModel(this, PageControlView.SubsystemAlertDefinition, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    static /* synthetic */ AlertSubsystemManagerLocal access$000(SubsystemAlertDefinitionUIBean x0) {
        return x0.manager;
    }

    static /* synthetic */ IntExtractor access$100(SubsystemAlertDefinitionUIBean x0) {
        return x0.RESOURCE_ID_EXTRACTOR;
    }

    static /* synthetic */ String access$202(SubsystemAlertDefinitionUIBean x0, String x1) {
        x0.resourceFilter = x1;
        return x0.resourceFilter;
    }

    static /* synthetic */ String access$302(SubsystemAlertDefinitionUIBean x0, String x1) {
        x0.parentFilter = x1;
        return x0.parentFilter;
    }

    static /* synthetic */ Date access$402(SubsystemAlertDefinitionUIBean x0, Date x1) {
        x0.dateBeginFilter = x1;
        return x0.dateBeginFilter;
    }

    static /* synthetic */ Date access$502(SubsystemAlertDefinitionUIBean x0, Date x1) {
        x0.dateEndFilter = x1;
        return x0.dateEndFilter;
    }

    static /* synthetic */ String access$602(SubsystemAlertDefinitionUIBean x0, String x1) {
        x0.categoryFilter = x1;
        return x0.categoryFilter;
    }

    static /* synthetic */ String access$700() {
        return datePattern;
    }
}

