/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.util;

import java.beans.Introspector;
import java.lang.reflect.Method;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.core.Init;
import org.rhq.enterprise.gui.util.LookupComponent;
import org.rhq.enterprise.server.util.LookupUtil;

@Startup
@Scope(value=ScopeType.APPLICATION)
@Name(value="lookupComponent")
public class LookupComponent {
    @In
    private Init init;
    @In
    private Context applicationContext;

    @Create
    public void scanComponents() {
        for (Method method : LookupUtil.class.getDeclaredMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("get")) continue;
            String componentName = this.getPropertyName(methodName);
            this.addComponent(componentName, method);
        }
    }

    private String getPropertyName(String getterMethodName) {
        return Introspector.decapitalize(getterMethodName.substring(3));
    }

    private void addComponent(String componentName, Method creationMethod) {
        LookupUtilComponent component = new LookupUtilComponent(this, componentName, creationMethod, null);
        this.applicationContext.set(componentName + ".component", (Object)component);
        this.init.addAutocreateVariable(componentName);
    }
}

