/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.admin.config;

import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.gui.admin.config.SystemConfigForm;
import org.rhq.enterprise.gui.legacy.action.BaseAction;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class EditConfigAction
extends BaseAction {
    Log log = LogFactory.getLog((String)EditConfigAction.class.getName());

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = this.checkSubmit(request, mapping, form);
        if (forward != null) {
            return forward;
        }
        Subject whoami = WebUtility.getSubject((HttpServletRequest)request);
        SystemConfigForm cForm = (SystemConfigForm)form;
        ServletContext ctx = this.getServlet().getServletContext();
        SystemManagerLocal systemManager = LookupUtil.getSystemManager();
        if (cForm.isOkClicked()) {
            try {
                this.log.trace((Object)"Getting config");
                Properties props = cForm.saveConfigProperties(systemManager.getSystemConfiguration(LookupUtil.getSubjectManager().getOverlord()));
                this.log.trace((Object)"Setting config");
                if (LookupUtil.getAuthorizationManager().isSystemSuperuser(whoami) && request.getParameter("debug") != null) {
                    systemManager.setSystemConfiguration(whoami, props, true);
                } else {
                    systemManager.setSystemConfiguration(whoami, props, false);
                }
                this.log.trace((Object)"Restarting config service");
                systemManager.reconfigureSystem(whoami);
                if (cForm.getLdapEnabled() != null) {
                    ctx.setAttribute("jaas-provider", (Object)"LDAP");
                } else {
                    ctx.setAttribute("jaas-provider", (Object)"JDBC");
                }
            }
            catch (Exception e) {
                String throwableMsgs = ThrowableUtil.getAllMessages((Throwable)e, (boolean)true);
                this.log.error((Object)("Failed to store server settings. Cause: " + throwableMsgs));
                RequestUtils.setErrorObject((HttpServletRequest)request, (String)"admin.config.confirm.saveSettingsFailure", (String)throwableMsgs);
                return this.returnFailure(request, mapping);
            }
        }
        RequestUtils.setConfirmation((HttpServletRequest)request, (String)"admin.config.confirm.saveSettings");
        return this.returnSuccess(request, mapping);
    }
}

