/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.StringUtility;
import org.rhq.enterprise.gui.alert.ListAlertDefinitionsUIBean;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ListAlertDefinitionsUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ListAlertDefinitionsUIBean";
    private AlertDefinitionManagerLocal alertDefinitionManager = LookupUtil.getAlertDefinitionManager();

    public String createNewAlertDefinition() {
        return "createNewAlertDefinition";
    }

    public String deleteSelectedAlertDefinitions() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selectedAlertDefinitions = this.getSelectedAlertDefinitions();
        int[] alertDefinitionIds = StringUtility.getIntArray((String[])selectedAlertDefinitions);
        try {
            int deleted = this.alertDefinitionManager.removeAlertDefinitions(subject, alertDefinitionIds);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted " + deleted + " alert definitions."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete alert definitions.", (Throwable)e);
        }
        return "success";
    }

    public String enableSelectedAlertDefinitions() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selectedAlertDefinitions = this.getSelectedAlertDefinitions();
        int[] alertDefinitionIds = StringUtility.getIntArray((String[])selectedAlertDefinitions);
        try {
            int enabled = this.alertDefinitionManager.enableAlertDefinitions(subject, alertDefinitionIds);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Enabled " + enabled + " alert definitions."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to enable alert definitions.", (Throwable)e);
        }
        return "success";
    }

    public String disableSelectedAlertDefinitions() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selectedAlertDefinitions = this.getSelectedAlertDefinitions();
        int[] alertDefinitionIds = StringUtility.getIntArray((String[])selectedAlertDefinitions);
        try {
            int disabled = this.alertDefinitionManager.disableAlertDefinitions(subject, alertDefinitionIds);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Disabled " + disabled + " alert definitions."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to disable alert definitions.", (Throwable)e);
        }
        return "success";
    }

    public String copySelectedAlertDefinitions() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selectedAlertDefinitions = this.getSelectedAlertDefinitions();
        Integer[] alertDefinitionIds = StringUtility.getIntegerArray((String[])selectedAlertDefinitions);
        try {
            this.alertDefinitionManager.copyAlertDefinitions(subject, alertDefinitionIds);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Copied " + alertDefinitionIds.length + " alert definitions into the disabled state.  Edit each as appropriate, and then renable."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to copy alert definitions.", (Throwable)e);
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListAlertDefinitionsDataModel(this, PageControlView.AlertDefinitionsList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedAlertDefinitions() {
        return FacesContextUtility.getRequest().getParameterValues("selectedAlertDefinitions");
    }

    static /* synthetic */ AlertDefinitionManagerLocal access$000(ListAlertDefinitionsUIBean x0) {
        return x0.alertDefinitionManager;
    }
}

