/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.alert;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.alert.ListGroupAlertDefinitionsUIBean;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.alert.GroupAlertDefinitionManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ListGroupAlertDefinitionsUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ListGroupAlertDefinitionsUIBean";
    private GroupAlertDefinitionManagerLocal groupAlertDefinitionManager = LookupUtil.getGroupAlertDefinitionManager();

    public String createNewAlertDefinition() {
        return "createNewAlertDefinition";
    }

    public String deleteSelectedAlertDefinitions() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selectedAlertDefinitions = this.getSelectedAlertDefinitions();
        Integer[] alertDefinitionIds = this.getIntegerArray(selectedAlertDefinitions);
        try {
            int deleted = this.groupAlertDefinitionManager.removeGroupAlertDefinitions(subject, alertDefinitionIds);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted " + deleted + " group alert definitions."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to delete group alert definitions.", (Throwable)e);
        }
        return "success";
    }

    public String enableSelectedAlertDefinitions() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selectedAlertDefinitions = this.getSelectedAlertDefinitions();
        Integer[] alertDefinitionIds = this.getIntegerArray(selectedAlertDefinitions);
        try {
            int enabled = this.groupAlertDefinitionManager.enableGroupAlertDefinitions(subject, alertDefinitionIds);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Enabled " + enabled + " group alert definitions."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to enable group alert definitions.", (Throwable)e);
        }
        return "success";
    }

    public String disableSelectedAlertDefinitions() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selectedAlertDefinitions = this.getSelectedAlertDefinitions();
        Integer[] alertDefinitionIds = this.getIntegerArray(selectedAlertDefinitions);
        try {
            int disabled = this.groupAlertDefinitionManager.disableGroupAlertDefinitions(subject, alertDefinitionIds);
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Disabled " + disabled + " group alert definitions."));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"Failed to disable group alert definitions.", (Throwable)e);
        }
        return "success";
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListGroupAlertDefinitionsDataModel(this, PageControlView.GroupAlertDefinitionsList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    private String[] getSelectedAlertDefinitions() {
        return FacesContextUtility.getRequest().getParameterValues("selectedAlertDefinitions");
    }

    private Integer[] getIntegerArray(String[] input) {
        Integer[] output = new Integer[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Integer.valueOf(input[i]);
        }
        return output;
    }

    static /* synthetic */ GroupAlertDefinitionManagerLocal access$000(ListGroupAlertDefinitionsUIBean x0) {
        return x0.groupAlertDefinitionManager;
    }
}

