/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.servlet;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.enterprise.gui.image.data.IHighLowDataPoint;
import org.rhq.enterprise.gui.legacy.beans.NumericMetricDataPoint;

public class HighLowMetricValue
extends NumericMetricDataPoint
implements IHighLowDataPoint {
    private double highValue;
    private double lowValue;
    private int count = 0;

    public HighLowMetricValue(double value, double highValue, double lowValue, long rtime) {
        super(new MeasurementDataNumericHighLowComposite(rtime, value, highValue, lowValue));
        this.highValue = highValue;
        this.lowValue = lowValue;
    }

    public HighLowMetricValue(double value, long rtime) {
        this(value, value, value, rtime);
    }

    public HighLowMetricValue(double value) {
        this(value, System.currentTimeMillis());
    }

    public HighLowMetricValue(Number objectValue, long rtime) {
        this(objectValue.doubleValue(), rtime);
    }

    public HighLowMetricValue(HighLowMetricValue objectValue, long rtime) {
        this(objectValue.getValue(), rtime);
    }

    public HighLowMetricValue(long value, long rtime) {
        this((double)value, rtime);
    }

    public HighLowMetricValue(MeasurementDataNumericHighLowComposite dataPoint) {
        this(dataPoint.getValue(), dataPoint.getHighValue(), dataPoint.getLowValue(), dataPoint.getTimestamp());
    }

    public Double getObjectValue() {
        return this.getValue();
    }

    public String getLabel() {
        return SimpleDateFormat.getDateTimeInstance().format(new Date(this.getTimestamp()));
    }

    public double getLowValue() {
        return this.lowValue;
    }

    public void setLowValue(double lowValue) {
        this.lowValue = lowValue;
    }

    public double getHighValue() {
        return this.highValue;
    }

    public void setHighValue(double highValue) {
        this.highValue = highValue;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public int compareTo(Object o) {
        HighLowMetricValue o2 = (HighLowMetricValue)o;
        double difference = this.getValue() - o2.getValue();
        if (difference < 0.0) {
            return -1;
        }
        if (difference > 0.0) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HighLowMetricValue) {
            HighLowMetricValue val = (HighLowMetricValue)obj;
            return this.getTimestamp() == val.getTimestamp() && this.getValue() == val.getValue();
        }
        return false;
    }

    public double[] getValues() {
        return new double[]{this.getValue()};
    }
}

