/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.gui.common.servlet.ParameterizedServlet;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;

public abstract class ImageServlet
extends ParameterizedServlet {
    public static final String IMAGE_FORMAT_PARAM = "imageFormat";
    public static final String IMAGE_FORMAT_PNG = "png";
    public static final String IMAGE_FORMAT_JPEG = "jpeg";
    private static final String[] VALID_IMAGE_FORMATS = new String[]{"png", "jpeg"};
    private static final String PNG_MIME_TYPE = "image/png";
    private static final String JPEG_MIME_TYPE = "image/jpeg";
    public static final String IMAGE_WIDTH_PARAM = "imageWidth";
    public static final int IMAGE_WIDTH_DEFAULT = 700;
    public static final String IMAGE_HEIGHT_PARAM = "imageHeight";
    public static final int IMAGE_HEIGHT_DEFAULT = 350;
    private Log log = LogFactory.getLog((String)ImageServlet.class.getName());
    private String imageFormat;
    private int imageWidth;
    private int imageHeight;

    public void init() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("java.awt.headless=" + System.getProperty("java.awt.headless")));
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Parsing parameters.");
            }
            this.parseParameters(request);
            Object imgObj = this.createImage(request);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Rendering image.");
            }
            ServletOutputStream out = response.getOutputStream();
            RequestUtils.bustaCache((ServletRequest)request, (ServletResponse)response);
            if (this.getImageFormat().equals(IMAGE_FORMAT_PNG)) {
                response.setContentType(PNG_MIME_TYPE);
                this.renderPngImage(out, imgObj);
            } else {
                response.setContentType(JPEG_MIME_TYPE);
                this.renderJpegImage(out, imgObj);
            }
            out.flush();
        }
        catch (IOException e) {
            this.log.debug((Object)"Error writing image to response.", (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)"Unknown error.", (Throwable)e);
            throw new ServletException("Unknown error.", (Throwable)e);
        }
    }

    protected abstract Object createImage(HttpServletRequest var1) throws ServletException;

    protected abstract void renderPngImage(ServletOutputStream var1, Object var2) throws IOException;

    protected abstract void renderJpegImage(ServletOutputStream var1, Object var2) throws IOException;

    protected void parseParameters(HttpServletRequest request) {
        this.imageFormat = this.parseStringParameter(request, IMAGE_FORMAT_PARAM, this.getDefaultImageFormat(), VALID_IMAGE_FORMATS);
        this.imageWidth = this.parseIntParameter(request, IMAGE_WIDTH_PARAM, this.getDefaultImageWidth());
        this.imageHeight = this.parseIntParameter(request, IMAGE_HEIGHT_PARAM, this.getDefaultImageHeight());
        this._logParameters();
    }

    protected String getImageFormat() {
        return this.imageFormat;
    }

    protected int getImageHeight() {
        return this.imageHeight;
    }

    protected int getImageWidth() {
        return this.imageWidth;
    }

    protected String getDefaultImageFormat() {
        return IMAGE_FORMAT_PNG;
    }

    protected int getDefaultImageWidth() {
        return 700;
    }

    protected int getDefaultImageHeight() {
        return 350;
    }

    private void _logParameters() {
        if (this.log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("Parameters:");
            sb.append("\n");
            sb.append("\t");
            sb.append(IMAGE_FORMAT_PARAM);
            sb.append(": ");
            sb.append(this.imageFormat);
            sb.append("\n");
            sb.append("\t");
            sb.append(IMAGE_WIDTH_PARAM);
            sb.append(": ");
            sb.append(this.imageWidth);
            sb.append("\n");
            sb.append("\t");
            sb.append(IMAGE_HEIGHT_PARAM);
            sb.append(": ");
            sb.append(this.imageHeight);
            this.log.debug((Object)sb.toString());
        }
    }
}

