/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.common.time.converter;

import java.text.DecimalFormat;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;

public class ShortDurationConverter
implements Converter {
    private static final long MILLIS_IN_SECOND = 1000L;
    private static final long MILLIS_IN_MINUTE = 60000L;
    private static final long MILLIS_IN_HOUR = 3600000L;
    private static final long MILLIS_IN_DAY = 86400000L;
    private static final long SECONDS_IN_MINUTE = 60L;
    private static final long SECONDS_IN_HOUR = 3600L;
    private static final long MINUTES_IN_HOUR = 60L;
    private static final long HOURS_IN_DAY = 24L;
    private static final long MINS_IN_DAY = 1440L;
    private static final long SECS_IN_DAY = 86400L;
    private static final DecimalFormat twoDigitFormatter = new DecimalFormat("0.00");

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        throw new UnsupportedOperationException("The " + ShortDurationConverter.class.getSimpleName() + " does not support getAsObject(FacesContext, UIComponent, String");
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        String suffix;
        double result;
        if (value == null) {
            return "0";
        }
        long millis = 0L;
        if (value instanceof Long) {
            millis = (Long)value;
        } else if (value instanceof Double) {
            millis = ((Double)value).longValue();
        } else {
            throw new IllegalArgumentException("The " + ShortDurationConverter.class.getSimpleName() + " converter does not support rendering objects of type " + value.getClass().getSimpleName());
        }
        int days = (int)(millis / 86400000L);
        int hours = (int)((millis %= 86400000L) / 3600000L);
        int mins = (int)((millis %= 3600000L) / 60000L);
        int secs = (int)((millis %= 60000L) / 1000L);
        millis %= 1000L;
        if (days > 0) {
            double fractionalDays = (double)hours / 24.0 + (double)mins / 1440.0 + (double)secs / 86400.0 + (double)millis / 8.64E7;
            result = (double)hours + fractionalDays;
            suffix = "d";
        } else if (hours > 0) {
            double fractionalHrs = (double)mins / 60.0 + (double)secs / 3600.0 + (double)millis / 3600000.0;
            result = (double)hours + fractionalHrs;
            suffix = "h";
        } else if (mins > 0) {
            double fractionalMins = (double)secs / 60.0 + (double)millis / 60000.0;
            result = (double)mins + fractionalMins;
            suffix = "m";
        } else if (secs > 0) {
            double fractionalSecs = (double)millis / 1000.0;
            result = (double)secs + fractionalSecs;
            suffix = "s";
        } else {
            result = millis;
            suffix = "ms";
        }
        return twoDigitFormatter.format(result) + suffix;
    }
}

