/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.configuration.group;

import javax.faces.application.FacesMessage;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.configuration.group.AbstractGroupResourceConfigurationUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.configuration.ConfigurationUpdateStillInProgressException;

public class EditGroupResourceConfigurationUIBean
extends AbstractGroupResourceConfigurationUIBean {
    public static final String VIEW_ID = "/rhq/group/configuration/editCurrent.xhtml";

    public void init() {
        this.loadConfigurations();
    }

    public void updateConfigurations() {
        try {
            this.getConfigurationSet().applyGroupConfiguration();
            this.getConfigurationManager().scheduleGroupResourceConfigurationUpdate(EnterpriseFacesContextUtility.getSubject(), this.getGroup().getId(), this.getResourceConfigurations());
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Group Resource Configuration update scheduled.");
            String viewId = "/rhq/group/configuration/history.xhtml";
        }
        catch (ConfigurationUpdateStillInProgressException updateException) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)"Configuration update is currently in progress. Please consider reviewing the changes before submitting.");
            String viewId = VIEW_ID;
        }
        catch (PermissionException e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)e.getLocalizedMessage());
            String viewId = "/rhq/group/configuration/viewCurrent.xhtml";
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to schedule group Resource Configuration update - cause: " + e));
            String viewId = VIEW_ID;
        }
    }

    public void cancel() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Edit canceled.");
    }

    public void reset() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"All properties reset to original values.");
    }

    private String getViewId(String toViewId) {
        String currentViewId = FacesContextUtility.getViewId();
        int currentPlainIndex = currentViewId.indexOf("-plain.xhtml");
        if (currentPlainIndex != -1) {
            toViewId = toViewId.substring(0, toViewId.length() - 6) + "-plain.xhtml";
        }
        return toViewId;
    }
}

