/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.configuration.history;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.StringUtility;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.configuration.history.ListConfigurationUpdateUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ListConfigurationUpdateUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ListConfigurationUpdateUIBean";
    private Resource resource;

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new ListResourcesDataModel(this, PageControlView.ConfigurationHistory, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    public String rollback() {
        String rollbackTo = null;
        try {
            rollbackTo = FacesContextUtility.getRequest().getParameter("selectedItems");
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            Resource resource = EnterpriseFacesContextUtility.getResource();
            ConfigurationManagerLocal manager = LookupUtil.getConfigurationManager();
            manager.rollbackResourceConfiguration(subject, resource.getId(), Integer.parseInt(rollbackTo));
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Rolled back resource configuration to version " + rollbackTo));
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to rollback resource configuration to version " + rollbackTo + ". Cause: " + ThrowableUtil.getAllMessages((Throwable)e, (boolean)true)));
        }
        return "success";
    }

    public String delete() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        ConfigurationManagerLocal manager = LookupUtil.getConfigurationManager();
        String[] selectedItems = FacesContextUtility.getRequest().getParameterValues("selectedItems");
        ArrayList<String> success = new ArrayList<String>();
        HashMap<String, String> failure = new HashMap<String, String>();
        String next = null;
        for (int i = 0; i < selectedItems.length; ++i) {
            try {
                next = selectedItems[i];
                Integer doomed = Integer.valueOf(next);
                manager.purgeResourceConfigurationUpdate(subject, doomed.intValue(), true);
                success.add(next);
                continue;
            }
            catch (Exception e) {
                failure.put(next, ThrowableUtil.getAllMessages((Throwable)e, (boolean)true));
            }
        }
        if (success.size() > 0) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("Deleted resource configuration update versions: " + StringUtility.getListAsDelimitedString(success)));
        }
        for (Map.Entry error : failure.entrySet()) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to delete resource configuration update version " + (String)error.getKey() + ". Cause: " + (String)error.getValue()));
        }
        return "success";
    }

    public String compare() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"The 'compare' feature is not yet implemented.");
        return "success";
    }

    static /* synthetic */ Resource access$000(ListConfigurationUpdateUIBean x0) {
        return x0.resource;
    }

    static /* synthetic */ Resource access$002(ListConfigurationUpdateUIBean x0, Resource x1) {
        x0.resource = x1;
        return x0.resource;
    }
}

