/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.content;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.content.RepoPackageVersionsUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class RepoPackageVersionsUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "RepoPackageVersionsUIBean";
    public static final String FORM_ID = "repoPackageVersionsListForm";
    public static final String FILTER_ID = "repoPackageVersionsListForm:packageFilter";
    private String packageFilter;

    public void installSelectedPackages() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selectedPackages = FacesContextUtility.getRequest().getParameterValues("selectedPackages");
        int repoId = Integer.valueOf(FacesContextUtility.getRequiredRequestParameter((String)"id"));
        RepoManagerLocal repoManager = LookupUtil.getRepoManagerLocal();
        ContentManagerLocal contentManager = LookupUtil.getContentManager();
        int[] packageIds = new int[selectedPackages.length];
        for (int i = 0; i < packageIds.length; ++i) {
            packageIds[i] = Integer.parseInt(selectedPackages[i]);
        }
        try {
            PageList resources = repoManager.findSubscribedResources(subject, repoId, PageControl.getUnlimitedInstance());
            int[] resourceIds = new int[resources.size()];
            for (int i = 0; i < resourceIds.length; ++i) {
                resourceIds[i] = ((Resource)resources.get(i)).getId();
            }
            contentManager.deployPackagesWithNote(subject, resourceIds, packageIds, "Repository package install");
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to deploy packages: " + packageIds + " to Resources subscribed to repository: " + repoId + " Error: " + e.getMessage()));
        }
    }

    public void deleteSelectedPackages() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        String[] selectedPackages = FacesContextUtility.getRequest().getParameterValues("selectedPackages");
        int repoId = Integer.valueOf(FacesContextUtility.getRequiredRequestParameter((String)"id"));
        RepoManagerLocal repoManager = LookupUtil.getRepoManagerLocal();
        int[] packageIds = new int[selectedPackages.length];
        for (int i = 0; i < packageIds.length; ++i) {
            packageIds[i] = Integer.parseInt(selectedPackages[i]);
        }
        try {
            if (!repoManager.deletePackageVersionsFromRepo(subject, repoId, packageIds)) {
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Not all packages where deleted because some of them are provided by content sources.");
            }
            this.dataModel = null;
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to delete packages: " + packageIds + " from repository: " + repoId + " Error: " + e.getMessage()));
        }
    }

    public DataModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new RepoPackageVersionsDataModel(this, PageControlView.RepoPackageVersionsList, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    public void init() {
        if (this.packageFilter == null) {
            this.packageFilter = FacesContextUtility.getOptionalRequestParameter((String)FILTER_ID);
        }
    }

    public String getPackageFilter() {
        return this.packageFilter;
    }

    public void setPackageFilter(String packageFilter) {
        this.packageFilter = packageFilter;
    }
}

