/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.definition.group;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.faces.model.SelectItem;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.converter.SelectItemUtils;
import org.rhq.enterprise.gui.definition.group.GroupDefinitionExpressionBuilderLibraryUIBean;
import org.rhq.enterprise.server.resource.group.definition.GroupDefinitionExpressionBuilderManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class GroupDefinitionExpressionBuilderLibraryUIBean {
    private String previousPropertyType;
    private String previousPlugin;
    private String previousResourceType;
    private String selectedResourceLevel;
    private String selectedPropertyType;
    private String selectedPlugin;
    private String selectedResourceType;
    private String selectedProperty;
    private String selectedComparison;
    private String enteredValue = "";
    private String selectedGroupBy;
    private String selectedUnset;
    private boolean groupby;
    private boolean unset;
    private boolean typeSelectionDisabled;
    private SelectItem[] resourceLevels;
    private SelectItem[] propertyTypes;
    private SelectItem[] plugins;
    private SelectItem[] resourceTypes;
    private SelectItem[] properties;
    private SelectItem[] comparisonTypes;

    public GroupDefinitionExpressionBuilderLibraryUIBean() {
        ArrayList<String> types = new ArrayList<String>();
        for (PropertyType type : PropertyType.values()) {
            types.add(type.getDisplayName());
        }
        this.setSelectedPropertyType((String)types.get(0));
        this.propertyTypes = SelectItemUtils.convertFromListString(types, (boolean)false);
        ArrayList<String> resourceLevels = new ArrayList<String>();
        for (ResourceLevel level : ResourceLevel.values()) {
            resourceLevels.add(level.getDisplayName());
        }
        this.setSelectedResourceLevel((String)resourceLevels.get(0));
        this.resourceLevels = SelectItemUtils.convertFromListString(resourceLevels, (boolean)false);
        ArrayList<String> comparisonTypes = new ArrayList<String>();
        for (Comparison comparison : Comparison.values()) {
            comparisonTypes.add(comparison.getDisplayName());
        }
        this.setSelectedComparison((String)resourceLevels.get(0));
        this.comparisonTypes = SelectItemUtils.convertFromListString(comparisonTypes, (boolean)false);
        ArrayList<String> pluginNames = new ArrayList<String>();
        for (Plugin plugin : LookupUtil.getPluginManager().getInstalledPlugins()) {
            pluginNames.add(plugin.getName());
        }
        Collections.sort(pluginNames);
        this.selectedPlugin = (String)pluginNames.get(0);
        this.plugins = SelectItemUtils.convertFromListString(pluginNames, (boolean)false);
        this.processPluginChange(this.selectedPlugin);
        this.processPropertiesForRendering();
    }

    private boolean selectedPropertyTypeChanged() {
        return this.changed(this.previousPropertyType, this.getSelectedPropertyType());
    }

    private boolean selectedPluginChanged() {
        return this.changed(this.previousPlugin, this.getSelectedPlugin());
    }

    private boolean selectedResourceTypeChanged() {
        return this.changed(this.previousResourceType, this.getSelectedResourceType());
    }

    private boolean changed(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return false;
        }
        if (s1 == null || s2 == null) {
            return true;
        }
        return !s1.equals(s2);
    }

    public String getSelectedPropertyType() {
        return this.selectedPropertyType;
    }

    public void setSelectedPropertyType(String propertyType) {
        this.selectedPropertyType = propertyType;
    }

    public String getSelectedPlugin() {
        return this.selectedPlugin;
    }

    public void setSelectedPlugin(String plugin) {
        this.selectedPlugin = plugin;
    }

    public String getSelectedResourceType() {
        return this.selectedResourceType;
    }

    public void setSelectedResourceType(String resourceType) {
        this.selectedResourceType = resourceType;
    }

    public String getSelectedResourceLevel() {
        return this.selectedResourceLevel;
    }

    public void setSelectedResourceLevel(String selectedResourceLevel) {
        this.selectedResourceLevel = selectedResourceLevel;
    }

    public String getSelectedProperty() {
        return this.selectedProperty;
    }

    public void setSelectedProperty(String selectedProperty) {
        this.selectedProperty = selectedProperty;
    }

    public String getSelectedComparison() {
        return this.selectedComparison;
    }

    public String getSelectedGroupBy() {
        return this.selectedGroupBy;
    }

    public void setSelectedGroupBy(String selectedGroupBy) {
        this.selectedGroupBy = selectedGroupBy;
    }

    public String getSelectedUnset() {
        return this.selectedUnset;
    }

    public void setSelectedUnset(String selectedUnset) {
        this.selectedUnset = selectedUnset;
    }

    public void setSelectedComparison(String selectedComparison) {
        this.selectedComparison = selectedComparison;
    }

    public String getEnteredValue() {
        return this.enteredValue;
    }

    public void setEnteredValue(String enteredValue) {
        this.enteredValue = enteredValue;
    }

    public boolean isGroupby() {
        return this.groupby;
    }

    public void setGroupby(boolean groupby) {
        this.groupby = groupby;
    }

    public boolean isUnset() {
        return this.unset;
    }

    public void setUnset(boolean unset) {
        this.unset = unset;
    }

    public SelectItem[] getPropertyTypes() {
        return this.propertyTypes;
    }

    public SelectItem[] getPlugins() {
        return this.plugins;
    }

    public SelectItem[] getResourceTypes() {
        return this.resourceTypes;
    }

    public SelectItem[] getProperties() {
        return this.properties;
    }

    public SelectItem[] getResourceLevels() {
        return this.resourceLevels;
    }

    public SelectItem[] getComparisonTypes() {
        return this.comparisonTypes;
    }

    public boolean isTypeSelectionDisabled() {
        this.typeSelectionDisabled = PropertyType.getFromDisplayName((String)this.selectedPropertyType) == PropertyType.RESOURCE || this.isGroupby() && PropertyType.getFromDisplayName((String)this.selectedPropertyType) == PropertyType.RESOURCE_TYPE || PropertyType.getFromDisplayName((String)this.selectedPropertyType) == PropertyType.RESOURCE_CATEGORY;
        return this.typeSelectionDisabled;
    }

    private int getResourceTypeId(String resourceTypeName, String pluginName) {
        try {
            return LookupUtil.getResourceTypeManager().getResourceTypeByNameAndPlugin(resourceTypeName, pluginName).getId();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String refreshData() {
        String requestParamPropertyType = (String)FacesContextUtility.getOptionalRequestParameter((String)"libraryForm:propertyType", String.class, (Object)this.selectedPropertyType);
        String requestParamPlugin = (String)FacesContextUtility.getOptionalRequestParameter((String)"libraryForm:plugin", String.class, (Object)this.selectedPlugin);
        String requestParamResourceType = (String)FacesContextUtility.getOptionalRequestParameter((String)"libraryForm:resourceType", String.class, (Object)this.selectedResourceType);
        this.selectedResourceLevel = (String)FacesContextUtility.getOptionalRequestParameter((String)"libraryForm:resourceLevel", String.class, (Object)"Resource");
        this.selectedProperty = FacesContextUtility.getOptionalRequestParameter((String)"libraryForm:property");
        this.selectedGroupBy = FacesContextUtility.getOptionalRequestParameter((String)"libraryForm:selectedGroupBy");
        this.selectedUnset = FacesContextUtility.getOptionalRequestParameter((String)"libraryForm:selectedUnset");
        this.groupby = Boolean.valueOf(this.selectedGroupBy);
        this.unset = Boolean.valueOf(this.selectedUnset);
        this.enteredValue = (String)FacesContextUtility.getOptionalRequestParameter((String)"libraryForm:value", String.class, (Object)"");
        this.selectedComparison = FacesContextUtility.getOptionalRequestParameter((String)"libraryForm:comparison");
        this.processPropertyTypeChange(requestParamPropertyType);
        this.processResourceTypeChange(requestParamResourceType);
        if (requestParamPlugin != null && !requestParamPlugin.equals(this.selectedPlugin)) {
            this.processPluginChange(requestParamPlugin);
        }
        this.typeSelectionDisabled = PropertyType.getFromDisplayName((String)this.selectedPropertyType) == PropertyType.RESOURCE || PropertyType.getFromDisplayName((String)this.selectedPropertyType) == PropertyType.RESOURCE_CATEGORY;
        this.processPropertiesForRendering();
        return "success";
    }

    private void processPropertyTypeChange(String newPropertyType) {
        this.selectedPropertyType = newPropertyType;
    }

    private void processPluginChange(String newPlugin) {
        this.selectedPlugin = newPlugin;
        try {
            Plugin plugin = LookupUtil.getPluginManager().getPlugin(this.selectedPlugin);
            if (null == plugin) {
                return;
            }
            List types = LookupUtil.getResourceTypeManager().getResourceTypesByPlugin(plugin.getName());
            ArrayList<String> typeNames = new ArrayList<String>();
            for (ResourceType type : types) {
                typeNames.add(type.getName());
            }
            Collections.sort(typeNames);
            this.selectedResourceType = typeNames.size() > 0 ? (String)typeNames.get(0) : null;
            this.resourceTypes = typeNames.size() == 0 ? new SelectItem[0] : SelectItemUtils.convertFromListString(typeNames, (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processResourceTypeChange(String newResourceType) {
        this.selectedResourceType = newResourceType;
    }

    private void processPropertiesForRendering() {
        this.previousPropertyType = this.selectedPropertyType;
        this.previousPlugin = this.selectedPlugin;
        this.previousResourceType = this.selectedResourceType;
        if (this.resourceTypes.length == 0) {
            this.properties = new SelectItem[0];
            return;
        }
        List<Object> propertyNames = new ArrayList();
        PropertyType type = PropertyType.getFromDisplayName((String)this.selectedPropertyType);
        String resourceType = this.selectedResourceType;
        String plugin = this.selectedPlugin;
        if (resourceType != null && plugin != null) {
            int resourceTypeId = this.getResourceTypeId(resourceType, plugin);
            GroupDefinitionExpressionBuilderManagerLocal expressionBuilderManager = null;
            expressionBuilderManager = LookupUtil.getGroupDefinitionExpressionBuilderManager();
            if (type == null) {
                throw new IllegalArgumentException("No property support for '" + this.selectedPropertyType + " yet.");
            }
            if (type == PropertyType.TRAIT) {
                propertyNames = expressionBuilderManager.getTraitPropertyNames(resourceTypeId);
            } else if (type == PropertyType.PLUGIN_CONFIGURATION) {
                propertyNames = expressionBuilderManager.getPluginConfigurationPropertyNames(resourceTypeId);
            } else if (type == PropertyType.RESOURCE_CONFIGURATION) {
                propertyNames = expressionBuilderManager.getResourceConfigurationPropertyNames(resourceTypeId);
            } else if (type == PropertyType.RESOURCE) {
                propertyNames = Arrays.asList("id", "name", "version", "availability");
            }
            if (propertyNames.size() == 0) {
                this.properties = new SelectItem[0];
            } else {
                this.properties = SelectItemUtils.convertFromListString(propertyNames, (boolean)false);
                if (this.selectedProperty == null || !propertyNames.contains(this.selectedProperty)) {
                    this.selectedProperty = (String)propertyNames.get(0);
                }
            }
        }
    }

    public String getExpression() {
        this.refreshData();
        StringBuilder buf = new StringBuilder();
        if (this.isGroupby()) {
            buf.append("groupby ");
        }
        if (this.isUnset()) {
            buf.append("empty ");
        }
        buf.append("resource.");
        switch (1.$SwitchMap$org$rhq$enterprise$gui$definition$group$GroupDefinitionExpressionBuilderLibraryUIBean$ResourceLevel[ResourceLevel.getFromDisplayName((String)this.selectedResourceLevel).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                buf.append("child.");
                break;
            }
            case 3: {
                buf.append("parent.");
                break;
            }
            case 4: {
                buf.append("grandParent.");
                break;
            }
            case 5: {
                buf.append("greatGrandParent.");
                break;
            }
            case 6: {
                buf.append("greatGreatGrandParent.");
            }
        }
        switch (1.$SwitchMap$org$rhq$enterprise$gui$definition$group$GroupDefinitionExpressionBuilderLibraryUIBean$PropertyType[PropertyType.getFromDisplayName((String)this.selectedPropertyType).ordinal()]) {
            case 1: {
                buf.append(this.selectedProperty);
                break;
            }
            case 2: {
                buf.append("type.plugin");
                break;
            }
            case 3: {
                buf.append("type.category");
                break;
            }
            case 4: {
                buf.append("trait[" + this.selectedProperty + "]");
                break;
            }
            case 5: {
                buf.append("pluginConfiguration[" + this.selectedProperty + "]");
                break;
            }
            case 6: {
                buf.append("resourceConfiguration[" + this.selectedProperty + "]");
            }
        }
        if (!this.groupby && !this.unset) {
            switch (1.$SwitchMap$org$rhq$enterprise$gui$definition$group$GroupDefinitionExpressionBuilderLibraryUIBean$Comparison[Comparison.getFromDisplayName((String)this.selectedComparison).ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    buf.append(".contains");
                    break;
                }
                case 3: {
                    buf.append(".startsWith");
                    break;
                }
                case 4: {
                    buf.append(".endsWith");
                }
            }
            buf.append(" = ");
            switch (1.$SwitchMap$org$rhq$enterprise$gui$definition$group$GroupDefinitionExpressionBuilderLibraryUIBean$PropertyType[PropertyType.getFromDisplayName((String)this.selectedPropertyType).ordinal()]) {
                case 1: 
                case 3: {
                    buf.append(this.enteredValue);
                    break;
                }
                case 2: {
                    String d = buf.toString();
                    buf.append(this.selectedPlugin);
                    buf.append("\n");
                    buf.append(d.replaceAll("plugin", "name"));
                    buf.append(this.selectedResourceType);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    buf.append(this.enteredValue);
                }
            }
        } else if (PropertyType.getFromDisplayName((String)this.selectedPropertyType) == PropertyType.RESOURCE_TYPE) {
            String d = buf.toString();
            buf.append("\n");
            buf.append(d.replaceAll("plugin", "name"));
        }
        return buf.toString();
    }
}

