/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.ha;

import javax.faces.application.FacesMessage;
import javax.faces.model.DataModel;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.common.framework.PagedDataTableUIBean;
import org.rhq.enterprise.gui.common.paging.PageControlView;
import org.rhq.enterprise.gui.ha.ViewServerUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.cloud.TopologyManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ViewServerUIBean
extends PagedDataTableUIBean {
    public static final String MANAGED_BEAN_NAME = "ViewServerUIBean";
    private AgentManagerLocal agentManager = LookupUtil.getAgentManager();
    private TopologyManagerLocal topologyManager = LookupUtil.getTopologyManager();
    private Server server;

    public ViewServerUIBean() {
        this.hasPermission();
        int serverId = (Integer)FacesContextUtility.getRequiredRequestParameter((String)"serverId", Integer.class);
        this.server = this.topologyManager.getServerById(serverId);
    }

    public DataModel getDataModel() {
        if (null == this.dataModel) {
            this.dataModel = new ViewServerDataModel(this, PageControlView.ServerConnectedAgentsView, MANAGED_BEAN_NAME);
        }
        return this.dataModel;
    }

    public Server getServer() {
        return this.server;
    }

    public String edit() {
        return "edit";
    }

    public String save() {
        try {
            this.topologyManager.updateServer(this.getSubject(), this.getServer());
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"This server's public address and ports have been updated.");
        }
        catch (Exception e) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Error: " + e.getMessage()));
            return "edit";
        }
        return "success";
    }

    public String cancel() {
        return "success";
    }

    private void hasPermission() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        if (!LookupUtil.getAuthorizationManager().hasGlobalPermission(subject, Permission.MANAGE_INVENTORY)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have the proper permissions to view or manage servers");
        }
    }

    static /* synthetic */ AgentManagerLocal access$000(ViewServerUIBean x0) {
        return x0.agentManager;
    }
}

