/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.group;

import javax.faces.application.FacesMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupUpdateException;
import org.rhq.enterprise.server.util.LookupUtil;

public class EditGroupGeneralPropertiesUIBean {
    private final Log log = LogFactory.getLog(EditGroupGeneralPropertiesUIBean.class);
    public static final String MANAGED_BEAN_NAME = "EditGroupGeneralPropertiesUIBean";
    private static final String OUTCOME_SUCCESS = "success";
    private static final String OUTCOME_FAILURE = "failure";
    private String name;
    private String description;
    private boolean recursive;
    private ResourceGroupManagerLocal resourceGroupManager = LookupUtil.getResourceGroupManager();

    public EditGroupGeneralPropertiesUIBean() {
        ResourceGroup resourceGroup = EnterpriseFacesContextUtility.getResourceGroup();
        this.name = resourceGroup.getName();
        this.description = resourceGroup.getDescription();
        this.recursive = resourceGroup.isRecursive();
    }

    public String begin() {
        return OUTCOME_SUCCESS;
    }

    public String update() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        ResourceGroup resourceGroup = EnterpriseFacesContextUtility.getResourceGroup();
        resourceGroup.setName(this.name);
        resourceGroup.setDescription(this.description);
        resourceGroup.setRecursive(this.recursive);
        try {
            this.resourceGroupManager.updateResourceGroup(subject, resourceGroup);
        }
        catch (ResourceGroupUpdateException rgue) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Problem updating group: " + rgue.getMessage()));
            this.log.error((Object)"Problem updating group: ", (Throwable)rgue);
            return OUTCOME_FAILURE;
        }
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"General properties updated.");
        return OUTCOME_SUCCESS;
    }

    public String cancel() {
        FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"General properties not updated.");
        return OUTCOME_SUCCESS;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }
}

