/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.model.SelectItem;
import javax.persistence.NoResultException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.content.Architecture;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.resource.CreateResourceHistory;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.gui.inventory.resource.UploadNewChildPackageUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.content.ContentUIManagerLocal;
import org.rhq.enterprise.server.resource.ResourceFactoryManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.util.LookupUtil;
import org.richfaces.model.UploadItem;

public class CreateNewPackageChildResourceUIBean {
    public static final String MANAGED_BEAN_NAME = "CreateNewPackageChildResourceUIBean";
    private static final String OUTCOME_SUCCESS_OR_FAILURE = "successOrFailure";
    private static final String OUTCOME_CANCEL = "cancel";
    private static final String DEFAULT_VERSION = "0";
    private final Log log = LogFactory.getLog(this.getClass());
    private ResourceType resourceType = this.lookupResourceType();
    private PackageType packageType = this.lookupPackageType();
    private String packageName;
    private String version = "0";
    private Integer selectedArchitectureId;
    private CreateResourceHistory retryCreateItem;
    private ConfigurationDefinition configurationDefinition = this.lookupConfigurationDefinition();
    private Configuration configuration = this.lookupConfiguration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String createResource() {
        Subject user = EnterpriseFacesContextUtility.getSubject();
        UploadNewChildPackageUIBean uploadUIBean = (UploadNewChildPackageUIBean)FacesContextUtility.getManagedBean(UploadNewChildPackageUIBean.class);
        UploadItem fileItem = uploadUIBean.getFileItem();
        HashMap<String, String> packageUploadDetails = new HashMap<String, String>();
        packageUploadDetails.put("fileSize", String.valueOf(fileItem.getFileSize()));
        packageUploadDetails.put("fileInstallDate", String.valueOf(System.currentTimeMillis()));
        packageUploadDetails.put("owner", user.getName());
        packageUploadDetails.put("fileName", fileItem.getFileName());
        try {
            packageUploadDetails.put("md5", new MessageDigestGenerator("MD5").calcDigestString(fileItem.getFile()));
            packageUploadDetails.put("sha256", new MessageDigestGenerator("SHA-256").calcDigestString(fileItem.getFile()));
        }
        catch (IOException e1) {
            this.log.warn((Object)("Error calculating file digest(s) : " + e1.getMessage()));
            e1.printStackTrace();
        }
        if (fileItem == null || fileItem.getFile() == null) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"A package file must be uploaded");
            return null;
        }
        if (this.getVersion() == null || this.getVersion().trim().length() == 0) {
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)"A package version must be specified.");
            return null;
        }
        ConfigurationManagerLocal configurationManager = LookupUtil.getConfigurationManager();
        ConfigurationDefinition pluginConfigurationDefinition = configurationManager.getPluginConfigurationDefinitionForResourceType(user, this.resourceType.getId());
        Configuration pluginConfiguration = null;
        if (pluginConfigurationDefinition != null) {
            pluginConfiguration = pluginConfigurationDefinition.getDefaultTemplate().getConfiguration();
        }
        try {
            this.log.debug((Object)("Streaming new package bits from uploaded file: " + fileItem.getFile()));
            FileInputStream packageContentStream = new FileInputStream(fileItem.getFile());
            if (this.isSupportsArchitecture()) {
                this.selectedArchitectureId = this.getSelectedArchitectureId();
            }
            Resource parentResource = EnterpriseFacesContextUtility.getResource();
            Configuration deployTimeConfiguration = this.getConfiguration();
            String packageName = fileItem.getFileName();
            if (packageName != null) {
                if ((packageName = packageName.replace('\\', '/')).length() > 2 && packageName.charAt(1) == ':') {
                    packageName = packageName.substring(2);
                }
                packageName = new File(packageName).getName();
            }
            try {
                ResourceFactoryManagerLocal resourceFactoryManager = LookupUtil.getResourceFactoryManager();
                if (packageUploadDetails != null) {
                    resourceFactoryManager.createResource(user, parentResource.getId(), this.getResourceTypeId(), null, pluginConfiguration, packageName, this.getVersion(), this.selectedArchitectureId, deployTimeConfiguration, (InputStream)packageContentStream, packageUploadDetails);
                } else {
                    resourceFactoryManager.createResource(user, parentResource.getId(), this.getResourceTypeId(), null, pluginConfiguration, packageName, null, this.selectedArchitectureId, deployTimeConfiguration, (InputStream)packageContentStream);
                }
            }
            catch (NoResultException nre) {
            }
            catch (Exception e) {
                String errorMessages = ThrowableUtil.getAllMessages((Throwable)e);
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to send create resource request to agent. Cause: " + errorMessages));
                this.log.error((Object)("Failed to create new child Resource of type [" + this.getResourceType() + "]."), (Throwable)e);
                String string = OUTCOME_SUCCESS_OR_FAILURE;
                ((InputStream)packageContentStream).close();
                this.cleanup(uploadUIBean);
                return string;
            }
            {
                catch (Throwable throwable) {
                    ((InputStream)packageContentStream).close();
                    throw throwable;
                }
            }
            try {
                ((InputStream)packageContentStream).close();
            }
            catch (IOException e) {
                String errorMessages = ThrowableUtil.getAllMessages((Throwable)e);
                FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)("Failed to retrieve the input stream. Cause: " + errorMessages));
                String string = OUTCOME_SUCCESS_OR_FAILURE;
                return string;
            }
            FacesContextUtility.addMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)"Create resource request successfully sent to the agent.");
        }
        finally {
            this.cleanup(uploadUIBean);
        }
        return OUTCOME_SUCCESS_OR_FAILURE;
    }

    public boolean isSupportsArchitecture() {
        return this.packageType.isSupportsArchitecture();
    }

    private void cleanup(UploadNewChildPackageUIBean uploadUIBean) {
        if (uploadUIBean != null) {
            uploadUIBean.clear();
        }
        this.configuration = null;
        this.configurationDefinition = null;
        this.packageType = null;
        this.resourceType = null;
    }

    public String cancel() {
        UploadNewChildPackageUIBean uploadUIBean = (UploadNewChildPackageUIBean)FacesContextUtility.getManagedBean(UploadNewChildPackageUIBean.class);
        this.cleanup(uploadUIBean);
        return OUTCOME_CANCEL;
    }

    public SelectItem[] getArchitectures() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        ContentManagerLocal contentManager = LookupUtil.getContentManager();
        List architectures = contentManager.findArchitectures(subject);
        SelectItem[] items = new SelectItem[architectures.size()];
        int itemCounter = 0;
        for (Architecture arch : architectures) {
            SelectItem item = new SelectItem((Object)arch.getId(), arch.getName());
            items[itemCounter++] = item;
        }
        return items;
    }

    private ResourceType lookupResourceType() {
        ResourceType resourceType;
        ResourceTypeManagerLocal resourceTypeManager = LookupUtil.getResourceTypeManager();
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        try {
            resourceType = resourceTypeManager.getResourceTypeById(subject, this.getResourceTypeId());
        }
        catch (ResourceTypeNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return resourceType;
    }

    private PackageType lookupPackageType() {
        if (this.resourceType == null) {
            this.resourceType = this.lookupResourceType();
        }
        ContentManagerLocal contentManager = LookupUtil.getContentManager();
        PackageType packageType = contentManager.getResourceCreationPackageType(this.resourceType.getId());
        return packageType;
    }

    protected ConfigurationDefinition lookupConfigurationDefinition() {
        if (this.packageType == null) {
            this.packageType = this.lookupPackageType();
        }
        ConfigurationDefinition configurationDefinition = this.packageType.getDeploymentConfigurationDefinition();
        return configurationDefinition;
    }

    protected Configuration lookupConfiguration() {
        ConfigurationTemplate deployTimeConfigurationTemplates = null;
        ConfigurationDefinition configDef = this.getConfigurationDefinition();
        if (configDef != null) {
            deployTimeConfigurationTemplates = configDef.getDefaultTemplate();
        }
        Configuration deployTimeConfiguration = deployTimeConfigurationTemplates != null ? deployTimeConfigurationTemplates.createConfiguration() : new Configuration();
        return deployTimeConfiguration;
    }

    public SelectItem[] getFailedCreateHistory() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        Resource parentResource = EnterpriseFacesContextUtility.getResource();
        ResourceFactoryManagerLocal resourceFactoryManager = LookupUtil.getResourceFactoryManager();
        PageControl pageControl = new PageControl(0, 1000);
        PageList pageList = resourceFactoryManager.findCreateChildResourceHistory(subject, parentResource.getId(), null, null, pageControl);
        ArrayList<SelectItem> selectItemsList = new ArrayList<SelectItem>();
        for (CreateResourceHistory history : pageList) {
            if (history.getStatus() != CreateResourceStatus.FAILURE && history.getStatus() != CreateResourceStatus.TIMED_OUT) continue;
            selectItemsList.add(new SelectItem((Object)history, history.getCreatedResourceName()));
        }
        SelectItem[] items = selectItemsList.toArray(new SelectItem[selectItemsList.size()]);
        return items;
    }

    public CreateResourceHistory getRetryCreateItem() {
        return this.retryCreateItem;
    }

    public void setRetryCreateItem(CreateResourceHistory retryCreateItem) {
        this.retryCreateItem = retryCreateItem;
    }

    public PackageType getPackageType() {
        if (this.packageType == null) {
            this.packageType = this.lookupPackageType();
        }
        return this.packageType;
    }

    public void setPackageType(PackageType packageType) {
        this.packageType = packageType;
    }

    public ResourceType getResourceType() {
        if (this.resourceType == null) {
            this.resourceType = this.lookupResourceType();
        }
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public int getSelectedArchitectureId() {
        return this.selectedArchitectureId;
    }

    public void setSelectedArchitectureId(int selectedArchitectureId) {
        this.selectedArchitectureId = selectedArchitectureId;
    }

    public ConfigurationDefinition getConfigurationDefinition() {
        if (this.configurationDefinition == null) {
            this.configurationDefinition = this.lookupConfigurationDefinition();
        }
        return this.configurationDefinition;
    }

    public Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.lookupConfiguration();
        }
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getNullConfigurationDefinitionMessage() {
        return "This resource type does not expose deployment-time configuration values.";
    }

    public String getNullConfigurationMessage() {
        return "Unable to create an initial deployment-time configuration for resource being added.";
    }

    private int getResourceTypeId() {
        try {
            return EnterpriseFacesContextUtility.getResourceType().getId();
        }
        catch (Exception e) {
            return (Integer)FacesContextUtility.getFacesContext().getExternalContext().getRequestMap().get("type");
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public SelectItem[] getPackageTypes() {
        Resource resource = EnterpriseFacesContextUtility.getResource();
        ContentUIManagerLocal contentUIManager = LookupUtil.getContentUIManager();
        List packageTypes = contentUIManager.getPackageTypes(resource.getResourceType().getId());
        SelectItem[] items = new SelectItem[packageTypes.size()];
        int itemCounter = 0;
        for (PackageType packageType : packageTypes) {
            SelectItem item = new SelectItem((Object)packageType.getId(), packageType.getDisplayName());
            items[itemCounter++] = item;
        }
        return items;
    }
}

