/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.inventory.resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.gui.inventory.resource.ResourceUIBean;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.WebUserPreferences;
import org.rhq.enterprise.gui.legacy.action.resource.common.QuickFavoritesUtil;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;

public class FavoritesUIBean {
    protected final Log log = LogFactory.getLog(FavoritesUIBean.class);
    private Boolean favorite;
    private ResourceUIBean resourceUIBean;

    public ResourceUIBean getResourceUIBean() {
        return this.resourceUIBean;
    }

    public void setResourceUIBean(ResourceUIBean resourceUIBean) {
        this.resourceUIBean = resourceUIBean;
    }

    public boolean isFavorite() {
        if (this.favorite == null) {
            this.log.debug((Object)("isFavorite for " + this.resourceUIBean.getId()));
            this.favorite = QuickFavoritesUtil.determineIfFavoriteResource((int)this.resourceUIBean.getId());
        }
        return this.favorite;
    }

    public String toggleFavorite() {
        this.log.debug((Object)("toggleFavorite for " + this.resourceUIBean.getId()));
        WebUser user = EnterpriseFacesContextUtility.getWebUser();
        WebUserPreferences preferences = user.getWebPreferences();
        WebUserPreferences.FavoriteResourcePortletPreferences favoriteResourcePreferences = preferences.getFavoriteResourcePortletPreferences();
        boolean isFav = favoriteResourcePreferences.isFavorite(this.resourceUIBean.getId());
        if (isFav) {
            favoriteResourcePreferences.removeFavorite(this.resourceUIBean.getId());
            this.log.debug((Object)("Removing favorite: " + this.resourceUIBean.getId()));
        } else {
            favoriteResourcePreferences.addFavorite(this.resourceUIBean.getId());
            this.log.debug((Object)("Adding favorite: " + this.resourceUIBean.getId()));
        }
        preferences.setFavoriteResourcePortletPreferences(favoriteResourcePreferences);
        this.favorite = !isFav;
        return null;
    }
}

