/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertConditionLog;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.server.MeasurementConverter;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.AlertDefUtil;
import org.rhq.enterprise.gui.legacy.beans.AlertConditionBean;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class ViewAlertAction
extends TilesAction {
    private Log log = LogFactory.getLog(ViewAlertAction.class);

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Subject subject = RequestUtils.getSubject((HttpServletRequest)request);
        AlertManagerLocal alertManager = LookupUtil.getAlertManager();
        Integer alertId = new Integer(request.getParameter("a"));
        this.log.trace((Object)("alertId=" + alertId));
        request.setAttribute("a", (Object)alertId);
        AlertCriteria criteria = new AlertCriteria();
        criteria.addFilterId(alertId);
        PageList results = alertManager.findAlertsByCriteria(subject, criteria);
        if (results.size() == 0) {
            throw new IllegalArgumentException("Alert with id " + alertId + " was not found");
        }
        Alert av = (Alert)results.get(0);
        AlertDefinition adv = av.getAlertDefinition();
        request.setAttribute("alert", (Object)av);
        request.setAttribute("alertDef", (Object)adv);
        Set condLogs = av.getConditionLogs();
        LinkedHashSet<AlertCondition> conds = new LinkedHashSet<AlertCondition>(condLogs.size());
        for (AlertConditionLog condLog : condLogs) {
            conds.add(condLog.getCondition());
        }
        List alertCondBeans = AlertDefUtil.getAlertConditionBeanList((Subject)subject, (HttpServletRequest)request, conds);
        Iterator condsIterator = conds.iterator();
        Iterator condLogsIterator = condLogs.iterator();
        for (AlertConditionBean alertCondBean : alertCondBeans) {
            AlertCondition cond = (AlertCondition)condsIterator.next();
            AlertConditionLog condLog = (AlertConditionLog)condLogsIterator.next();
            AlertConditionCategory category = cond.getCategory();
            if (category == AlertConditionCategory.CONTROL) {
                alertCondBean.setActualValue(RequestUtils.message((HttpServletRequest)request, (String)"alert.current.list.ControlActualValue"));
                continue;
            }
            if (category == AlertConditionCategory.THRESHOLD || category == AlertConditionCategory.BASELINE || category == AlertConditionCategory.CHANGE) {
                String firedValue;
                MeasurementDefinition definition = condLog.getCondition().getMeasurementDefinition();
                try {
                    firedValue = MeasurementConverter.format((Double)Double.valueOf(condLog.getValue()), (MeasurementUnits)definition.getUnits(), (boolean)true);
                }
                catch (Exception e) {
                    firedValue = definition.getDataType() == DataType.CALLTIME ? condLog.getValue() : "??";
                }
                alertCondBean.setActualValue(firedValue);
                continue;
            }
            if (category == AlertConditionCategory.RESOURCE_CONFIG || category == AlertConditionCategory.EVENT) {
                alertCondBean.setActualValue(condLog.getValue());
                continue;
            }
            if (category == AlertConditionCategory.TRAIT) {
                alertCondBean.setActualValue(condLog.getValue());
                continue;
            }
            alertCondBean.setActualValue("??");
        }
        request.setAttribute("conditionExpression", (Object)adv.getConditionExpression().name());
        request.setAttribute("alertDefConditions", (Object)alertCondBeans);
        List notificationLogs = av.getAlertNotificationLogs();
        request.setAttribute("aNotifLogs", (Object)notificationLogs);
        int recoveryAlertDefId = adv.getRecoveryId();
        if (recoveryAlertDefId != 0) {
            String recoveryAlertName = this.getRecoveryAlertName(recoveryAlertDefId, subject);
            request.setAttribute("recoveryAlertName", (Object)recoveryAlertName);
        }
        AlertDefUtil.setAlertDampeningRequestAttributes((HttpServletRequest)request, (AlertDefinition)adv);
        request.setAttribute("cTime", (Object)this.parseDate(Long.valueOf(av.getCtime())));
        return null;
    }

    private String getRecoveryAlertName(int alertDefinitionId, Subject user) {
        try {
            AlertDefinition alertDefinition = LookupUtil.getAlertDefinitionManager().getAlertDefinitionById(user, alertDefinitionId);
            return alertDefinition.getName();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String parseDate(Long dateLong) {
        SimpleDateFormat formatter = new SimpleDateFormat("M/d/yy, h:mm:ss aa, zzz");
        Date date = new Date(dateLong);
        return formatter.format(date);
    }
}

