/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.apache.struts.util.LabelValueBean;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.ResourceFacets;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.gui.legacy.action.resource.ResourceForm;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.alerts.config.DefinitionForm;
import org.rhq.enterprise.gui.legacy.beans.OptionItem;
import org.rhq.enterprise.gui.legacy.beans.RelatedOptionBean;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.measurement.util.MeasurementFormatter;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public abstract class DefinitionFormPrepareAction
extends TilesAction {
    protected Log log = LogFactory.getLog(DefinitionFormPrepareAction.class);

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isExperimental;
        DefinitionForm defForm = (DefinitionForm)form;
        this.setupForm(defForm, request);
        if (!defForm.isOkClicked()) {
            this.setupConditions(request, defForm);
        }
        if (defForm.isAddClicked()) {
            defForm.setNumConditions(defForm.getNumConditions() + 1);
        } else if (defForm.isRemoveClicked()) {
            int ri = Integer.parseInt(defForm.getRemove().getX());
            this.log.trace((Object)("deleting condition # " + ri));
            defForm.deleteCondition(ri);
        }
        this.log.trace((Object)("defForm.numConditions=" + defForm.getNumConditions()));
        request.setAttribute("numConditions", (Object)defForm.getNumConditions());
        boolean triggerNotSet = defForm.getCondition(0).getTrigger() == null;
        ResourceType type = null;
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        ResourceForm.FormContext formContext = defForm.getContext();
        if (formContext == ResourceForm.FormContext.Type) {
            type = LookupUtil.getResourceTypeManager().getResourceTypeById(overlord, defForm.getType().intValue());
        } else if (formContext == ResourceForm.FormContext.Resource) {
            type = LookupUtil.getResourceManager().getResourceById(overlord, defForm.getId().intValue()).getResourceType();
        } else if (formContext == ResourceForm.FormContext.Group) {
            type = LookupUtil.getResourceGroupManager().getResourceGroup(overlord, defForm.getGroupId().intValue()).getResourceType();
        } else {
            throw new IllegalArgumentException("Unsupported context: " + formContext);
        }
        ResourceFacets facets = LookupUtil.getResourceTypeManager().getResourceFacets(type.getId());
        request.setAttribute("showEvents", (Object)facets.isEvent());
        if (facets.isEvent() && triggerNotSet) {
            defForm.getCondition(0).setTrigger("onEvent");
        }
        request.setAttribute("showOperations", (Object)(defForm.getControlActions().size() > 0 ? 1 : 0));
        if (defForm.getControlActions().size() > 0 && triggerNotSet) {
            defForm.getCondition(0).setTrigger("onOperation");
        }
        request.setAttribute("showAvailability", (Object)(defForm.getAvailabilityOptions().length > 0 ? 1 : 0));
        if (defForm.getAvailabilityOptions().length > 0 && triggerNotSet) {
            defForm.getCondition(0).setTrigger("onAvailability");
        }
        request.setAttribute("showResourceConfiguration", (Object)defForm.isResourceConfigurationSupported());
        if (defForm.isResourceConfigurationSupported() && triggerNotSet) {
            defForm.getCondition(0).setTrigger("onResourceConfiguration");
        }
        request.setAttribute("showTraits", (Object)(defForm.getTraits().size() > 0 ? 1 : 0));
        if (defForm.getTraits().size() > 0 && triggerNotSet) {
            defForm.getCondition(0).setTrigger("onTrait");
        }
        request.setAttribute("showCalltimeMetrics", (Object)((isExperimental = LookupUtil.getSystemManager().isExperimentalFeaturesEnabled()) && defForm.getCalltimeMetrics().size() > 0 ? 1 : 0));
        if (defForm.getCalltimeMetrics().size() > 0 && triggerNotSet) {
            defForm.getCondition(0).setTrigger("onCallTime");
        }
        request.setAttribute("showMetrics", (Object)(defForm.getMetrics().size() > 0 ? 1 : 0));
        if (defForm.getMetrics().size() > 0 && triggerNotSet) {
            defForm.getCondition(0).setTrigger("onMeasurement");
        }
        return null;
    }

    protected void setupForm(DefinitionForm defForm, HttpServletRequest request) throws Exception {
        RelatedOptionBean rob;
        request.setAttribute("dampenNone", (Object)AlertDampening.Category.NONE.ordinal());
        request.setAttribute("dampenConsecutiveCount", (Object)AlertDampening.Category.CONSECUTIVE_COUNT.ordinal());
        request.setAttribute("dampenPartialCount", (Object)AlertDampening.Category.PARTIAL_COUNT.ordinal());
        request.setAttribute("dampenInverseCount", (Object)AlertDampening.Category.INVERSE_COUNT.ordinal());
        request.setAttribute("dampenDurationCount", (Object)AlertDampening.Category.DURATION_COUNT.ordinal());
        request.setAttribute("noneDeleted", (Object)-1);
        MeasurementScheduleManagerLocal scheduleManager = LookupUtil.getMeasurementScheduleManager();
        MeasurementDefinitionManagerLocal definitionManager = LookupUtil.getMeasurementDefinitionManager();
        ConfigurationManagerLocal configurationManager = LookupUtil.getConfigurationManager();
        Subject subject = RequestUtils.getSubject((HttpServletRequest)request);
        Resource resource = RequestUtils.getResource((HttpServletRequest)request);
        ResourceGroup group = RequestUtils.getResourceGroupIfExists((HttpServletRequest)request);
        ResourceType type = null;
        type = resource != null ? resource.getResourceType() : (group != null ? group.getResourceType() : RequestUtils.getResourceType((HttpServletRequest)request));
        defForm.setResourceType(Integer.valueOf(type.getId()));
        List dataDefinitions = definitionManager.findMeasurementDefinitionsByResourceType(subject, type.getId(), DataType.MEASUREMENT, null);
        List calltimeDefinitions = definitionManager.findMeasurementDefinitionsByResourceType(subject, type.getId(), DataType.CALLTIME, null);
        List traitDefinitions = definitionManager.findMeasurementDefinitionsByResourceType(subject, type.getId(), DataType.TRAIT, null);
        ArrayList<RelatedOptionBean> baselines = new ArrayList<RelatedOptionBean>();
        if (resource != null) {
            MeasurementSchedule schedule;
            for (MeasurementDefinition definition : dataDefinitions) {
                schedule = scheduleManager.getSchedule(subject, resource.getId(), definition.getId(), false);
                rob = new RelatedOptionBean((Object)definition.getName(), (Object)String.valueOf(definition.getId()), this.getBaselineList(schedule));
                baselines.add(rob);
                this.setDisabledName(schedule, definition);
            }
            for (MeasurementDefinition definition : traitDefinitions) {
                schedule = scheduleManager.getSchedule(subject, resource.getId(), definition.getId(), false);
                this.setDisabledName(schedule, definition);
            }
        } else {
            List defaultBaselineLabels = this.getBaselineList(null);
            for (MeasurementDefinition definition : dataDefinitions) {
                rob = new RelatedOptionBean((Object)definition.getName(), (Object)String.valueOf(definition.getId()), defaultBaselineLabels);
                baselines.add(rob);
            }
        }
        defForm.setMetrics(dataDefinitions);
        defForm.setCalltimeMetrics(calltimeDefinitions);
        defForm.setTraits(traitDefinitions);
        defForm.setBaselines(baselines);
        request.setAttribute("baselines", baselines);
        ArrayList<OptionItem> controlActions = new ArrayList<OptionItem>();
        OperationManagerLocal operationManager = LookupUtil.getOperationManager();
        for (OperationDefinition action : operationManager.findSupportedResourceTypeOperations(subject, type.getId(), false)) {
            OptionItem actionItem = new OptionItem(action.getDisplayName(), action.getName());
            controlActions.add(actionItem);
        }
        defForm.setControlActions(controlActions);
        ConfigurationDefinition configurationDefinition = configurationManager.getResourceConfigurationDefinitionForResourceType(subject, type.getId());
        defForm.setResourceConfigurationSupported(configurationDefinition != null);
    }

    private void setDisabledName(MeasurementSchedule schedule, MeasurementDefinition definition) {
        if (schedule == null) {
            return;
        }
        if (!schedule.isEnabled()) {
            String definitionName = definition.getDisplayName();
            definition.setDisplayName(definitionName + " (disabled)");
        }
    }

    protected abstract void setupConditions(HttpServletRequest var1, DefinitionForm var2) throws Exception;

    private List<LabelValueBean> getBaselineList(MeasurementSchedule schedule) {
        ArrayList<LabelValueBean> list = new ArrayList<LabelValueBean>(3);
        String minLabel = MeasurementFormatter.getBaselineText((String)"min", (MeasurementSchedule)schedule);
        list.add(new LabelValueBean(minLabel, "min"));
        String meanLabel = MeasurementFormatter.getBaselineText((String)"mean", (MeasurementSchedule)schedule);
        list.add(new LabelValueBean(meanLabel, "mean"));
        String maxLabel = MeasurementFormatter.getBaselineText((String)"max", (MeasurementSchedule)schedule);
        list.add(new LabelValueBean(maxLabel, "max"));
        return list;
    }
}

