/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.taglib;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.core.ConditionalTagSupport;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.enterprise.gui.legacy.taglib.Authorization;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class Authorization
extends ConditionalTagSupport {
    private static final long serialVersionUID = 1L;
    private String permission;

    protected boolean condition() throws JspTagException {
        try {
            int groupId;
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            AuthorizationManagerLocal authorizationManager = LookupUtil.getAuthorizationManager();
            Subject user = WebUtility.getSubject((HttpServletRequest)request);
            if (this.isSuperuserCheck()) {
                return authorizationManager.isSystemSuperuser(user);
            }
            Permission permission = this.getPermissionEnum();
            if (user == null) {
                return false;
            }
            Context context = Context.Global;
            int resourceId = this.getResourceId(request);
            if (resourceId != 0) {
                context = Context.Resource;
            }
            if ((groupId = this.getResourceGroupId(request)) != 0) {
                context = Context.Group;
            }
            if (context == Context.Resource) {
                return authorizationManager.hasResourcePermission(user, permission, resourceId);
            }
            if (context == Context.Group) {
                return authorizationManager.hasGroupPermission(user, permission, groupId);
            }
            if (context == Context.Global) {
                return authorizationManager.hasGlobalPermission(user, permission);
            }
            throw new JspTagException("Authorization tag does not yet support the context[" + context + "]");
        }
        catch (JspTagException jte) {
            throw jte;
        }
        catch (Exception e) {
            throw new JspTagException((Throwable)e);
        }
    }

    private int getResourceId(HttpServletRequest request) throws JspTagException {
        Integer id = WebUtility.getResourceId((ServletRequest)request);
        if (id == null) {
            return 0;
        }
        return id;
    }

    private int getResourceGroupId(HttpServletRequest request) throws JspTagException {
        Integer groupId = WebUtility.getResourceGroupId((ServletRequest)request);
        if (groupId == null) {
            return 0;
        }
        return groupId;
    }

    private boolean isSuperuserCheck() {
        return this.permission != null && this.permission.toLowerCase().equals("superuser");
    }

    private Permission getPermissionEnum() throws JspTagException {
        String permissionName = this.getPermission();
        try {
            return Permission.valueOf((String)permissionName.toUpperCase());
        }
        catch (Exception innerE) {
            throw new JspTagException("Invalid permission[" + permissionName + "]");
        }
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }
}

