/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.legacy.taglib.display;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

class SmartListHelper {
    private List masterList;
    private int pageSize;
    private int pageCount;
    private int currentPage;
    private int extSize = -1;
    private Properties prop = null;

    protected SmartListHelper(List list, int pageSize, Properties prop, Integer extSize) {
        if (list == null) {
            throw new IllegalArgumentException("Bad list argument passed into SmartListHelper() constructor");
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("Bad pageSize argument passed into SmartListHelper() constructor");
        }
        this.prop = prop;
        this.pageSize = pageSize;
        this.masterList = list;
        try {
            this.extSize = extSize;
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.pageCount = this.computedPageCount();
        this.currentPage = 1;
    }

    protected int computedPageCount() {
        int result = 0;
        if (this.masterList != null && this.pageSize > 0) {
            int size = this.masterList.size();
            int div = size / this.pageSize;
            int mod = size % this.pageSize;
            result = mod == 0 ? div : div + 1;
        }
        return result;
    }

    protected int getFirstIndexForCurrentPage() {
        return this.getFirstIndexForPage(this.currentPage);
    }

    protected int getLastIndexForCurrentPage() {
        return this.getLastIndexForPage(this.currentPage);
    }

    protected int getFirstIndexForPage(int page) {
        return (page - 1) * this.pageSize;
    }

    protected int getLastIndexForPage(int page) {
        int firstIndex = this.getFirstIndexForPage(page);
        int pageIndex = this.pageSize - 1;
        int lastIndex = this.masterList.size() - 1;
        return Math.min(firstIndex + pageIndex, lastIndex);
    }

    protected List getListForCurrentPage() {
        return this.getListForPage(this.currentPage);
    }

    protected List getListForPage(int page) {
        ArrayList list = new ArrayList(this.pageSize + 1);
        int firstIndex = this.getFirstIndexForPage(page);
        int lastIndex = this.getLastIndexForPage(page);
        for (int i = firstIndex; i <= lastIndex; ++i) {
            list.add(this.masterList.get(i));
        }
        return list;
    }

    protected void setCurrentPage(int page) {
        if (page < 1 || page > this.pageCount) {
            Object[] objs = new Object[]{new Integer(page), new Integer(this.pageCount)};
            throw new IllegalArgumentException(MessageFormat.format(this.prop.getProperty("error.msg.invalid_page"), objs));
        }
        this.currentPage = page;
    }

    protected String getSearchResultsSummary() {
        if (this.masterList.size() == 0) {
            Object[] objs = new Object[]{this.prop.getProperty("paging.banner.items_name")};
            return MessageFormat.format(this.prop.getProperty("paging.banner.no_items_found"), objs);
        }
        if (this.masterList.size() == 1) {
            Object[] objs = new Object[]{this.prop.getProperty("paging.banner.item_name")};
            return MessageFormat.format(this.prop.getProperty("paging.banner.one_item_found"), objs);
        }
        if (this.getFirstIndexForCurrentPage() == this.getLastIndexForCurrentPage()) {
            Object[] objs = new Object[]{new Integer(this.masterList.size()), this.prop.getProperty("paging.banner.items_name"), this.prop.getProperty("paging.banner.items_name")};
            return MessageFormat.format(this.prop.getProperty("paging.banner.all_items_found"), objs);
        }
        Object[] objs = new Object[]{new Integer(this.masterList.size()), this.prop.getProperty("paging.banner.items_name"), new Integer(this.getFirstIndexForCurrentPage() + 1), new Integer(this.getLastIndexForCurrentPage() + 1)};
        return MessageFormat.format(this.prop.getProperty("paging.banner.some_items_found"), objs);
    }

    protected String getPageNavigationBar(String urlFormatString, HttpServletRequest request, boolean pageAtServer) {
        Object[] v1;
        MessageFormat form = new MessageFormat(urlFormatString);
        int maxPages = 8;
        try {
            maxPages = Integer.parseInt(this.prop.getProperty("paging.banner.group_size"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int currentPage = this.currentPage;
        int pageCount = this.pageCount;
        int startPage = 1;
        int endPage = maxPages;
        if (pageCount == 1 || pageCount == 0) {
            return "<b>1</b>";
        }
        if (currentPage < maxPages) {
            startPage = 1;
            endPage = maxPages;
            if (pageCount < endPage) {
                endPage = pageCount;
            }
        } else {
            startPage = currentPage;
            while (startPage + maxPages > pageCount + 1) {
                --startPage;
            }
            endPage = startPage + (maxPages - 1);
        }
        boolean includeFirstLast = this.prop.getProperty("paging.banner.include_first_last").equals("true");
        boolean includePreviousNext = this.prop.getProperty("paging.banner.include_previous_next").equals("true");
        String msg = "";
        if (currentPage == 1) {
            if (includeFirstLast) {
                msg = msg + "[" + this.prop.getProperty("paging.banner.first_label");
            }
            if (includePreviousNext) {
                msg = msg + "[" + this.prop.getProperty("paging.banner.prev_label") + "] ";
            }
        } else {
            Object[] objs = new Object[]{new Integer(currentPage - 1)};
            v1 = new Object[]{new Integer(1)};
            if (includeFirstLast) {
                msg = msg + "[<a href=\"" + form.format(v1) + "\">" + this.prop.getProperty("paging.banner.first_label") + "</a>/<a href=\"" + form.format(objs) + "\">";
            }
            if (includePreviousNext) {
                msg = msg + "[<a href=\"" + form.format(objs) + "\">" + this.prop.getProperty("paging.banner.prev_label") + "</a>] ";
            }
        }
        for (int i = startPage; i <= endPage; ++i) {
            if (i == currentPage) {
                msg = msg + "<b>" + i + "</b>";
            } else {
                Object[] v = new Object[]{new Integer(i)};
                String sort = request.getParameter("sort");
                String order = request.getParameter("order");
                String pageSize = request.getParameter("pageSize");
                String pagMsg = order == null ? "&order=asc" : "&order=" + order;
                pagMsg = sort == null ? pagMsg + "&sort=1" : pagMsg + "&sort=" + sort;
                pagMsg = pageSize == null ? pagMsg + "&pageSize=" + this.prop.getProperty("paging.banner.default.page_size") : pagMsg + "&pageSize=" + pageSize;
                msg = msg + "<a href=\"" + form.format(v) + pagMsg + "\">" + i + "</a>";
            }
            msg = i != endPage ? msg + ", " : msg + " ";
        }
        if (currentPage == pageCount) {
            if (includeFirstLast) {
                msg = msg + "[" + this.prop.getProperty("paging.banner.next_label");
            }
            if (includePreviousNext) {
                msg = msg + "[" + this.prop.getProperty("paging.banner.next_label") + "] ";
            }
        } else {
            Object[] objs = new Object[]{new Integer(currentPage + 1)};
            v1 = new Object[]{new Integer(pageCount)};
            if (includeFirstLast) {
                msg = msg + "[<a href=\"" + form.format(objs) + "\">";
            }
            if (includePreviousNext) {
                msg = msg + "[<a href=\"" + form.format(objs) + "\">" + this.prop.getProperty("paging.banner.next_label") + "</a>] ";
            }
        }
        return msg;
    }
}

