/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.measurement.graphs;

import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.measurement.ui.MetricDisplaySummary;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.legacy.WebUser;
import org.rhq.enterprise.gui.legacy.action.resource.common.monitor.visibility.IndicatorViewsForm;
import org.rhq.enterprise.gui.legacy.util.MonitorUtils;
import org.rhq.enterprise.gui.legacy.util.RequestUtils;
import org.rhq.enterprise.gui.legacy.util.SessionUtils;
import org.rhq.enterprise.gui.measurement.graphs.IndicatorChartsUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.gui.util.MetricsDisplayMode;
import org.rhq.enterprise.gui.util.WebUtility;
import org.rhq.enterprise.server.auth.SessionNotFoundException;
import org.rhq.enterprise.server.auth.SessionTimeoutException;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.measurement.MeasurementChartsManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;
import org.rhq.enterprise.server.measurement.MeasurementViewException;
import org.rhq.enterprise.server.measurement.MeasurementViewManagerLocal;
import org.rhq.enterprise.server.measurement.util.MeasurementUtils;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class IndicatorChartsUIBean {
    private static final Log log = LogFactory.getLog(IndicatorChartsUIBean.class);
    private MeasurementChartsManagerLocal chartsManager = LookupUtil.getMeasurementChartsManager();
    private MeasurementViewManagerLocal viewManager = LookupUtil.getMeasurementViewManager();
    EntityContext context;
    List<MetricDisplaySummary> data = new ArrayList();
    List<String> views;
    String view;
    String groupType;

    public EntityContext getContext() {
        return this.context;
    }

    public List<MetricDisplaySummary> getData() {
        return this.data;
    }

    public List<String> getViews() {
        return this.views;
    }

    public String getView() {
        return this.view;
    }

    public String getGroupType() {
        return this.groupType;
    }

    public IndicatorChartsUIBean() {
        log.debug((Object)("Creating " + IndicatorChartsUIBean.class.getSimpleName()));
        WebUser user = EnterpriseFacesContextUtility.getWebUser();
        Subject subject = user.getSubject();
        try {
            HttpServletRequest request = FacesContextUtility.getRequest();
            this.context = WebUtility.getEntityContext((HttpServletRequest)request);
            this.groupType = WebUtility.getOptionalRequestParameter((ServletRequest)request, (String)"groupType", (String)"group");
            this.view = this.viewManager.getSelectedView(subject, this.context);
            this.views = this.viewManager.getViewNames(subject, this.context);
            if (this.context.type == EntityContext.Type.Resource) {
                this.data = this.chartsManager.getMetricDisplaySummariesForResource(subject, this.context.resourceId, this.view);
            } else if (this.context.type == EntityContext.Type.ResourceGroup) {
                this.data = this.chartsManager.getMetricDisplaySummariesForCompatibleGroup(subject, this.context.groupId, this.view);
            } else if (this.context.type == EntityContext.Type.AutoGroup) {
                this.data = this.chartsManager.getMetricDisplaySummariesForAutoGroup(subject, this.context.parentResourceId, this.context.resourceTypeId, this.view);
                this.groupType = "auto";
            }
            if (this.data != null) {
                MeasurementPreferences.MetricViewData viewData = new MeasurementPreferences.MetricViewData();
                viewData.charts = new ArrayList();
                for (MetricDisplaySummary mds : this.data) {
                    String chart = this.getContextKeyChart(this.context, mds);
                    log.debug((Object)("Chart was " + chart));
                    viewData.charts.add(chart);
                }
                this.viewManager.saveCharts(subject, this.context, this.view, viewData.charts);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while looking up metric chart data for " + this.context), (Throwable)e);
        }
        for (MetricDisplaySummary summary : this.data) {
            summary.setMetricToken(this.getContextKeyChart(this.context, summary));
            MonitorUtils.formatSimpleMetrics((MetricDisplaySummary)summary, null);
        }
    }

    private String getContextKeyChart(MetricDisplaySummary summary) {
        MetricsDisplayMode mode = this.getDisplayModeForSummary(summary);
        switch (1.$SwitchMap$org$rhq$enterprise$gui$util$MetricsDisplayMode[mode.ordinal()]) {
            case 1: {
                if (summary.getScheduleId() != null) {
                    return summary.getResourceId() + "," + summary.getScheduleId().toString();
                }
                throw new IllegalStateException("MetricsDisplayMode was 'RESOURCE', but the scheduleId was null");
            }
            case 2: {
                return "cg," + summary.getGroupId() + "," + summary.getDefinitionId();
            }
            case 3: {
                return "ag," + summary.getParentId() + "," + summary.getDefinitionId() + "," + summary.getChildTypeId();
            }
        }
        throw new IllegalArgumentException("Unknown or unsupported MetricsDisplayMode '" + mode + "'");
    }

    private String getContextKeyChart(EntityContext context, MetricDisplaySummary summary) {
        if (context.type == EntityContext.Type.Resource) {
            if (summary.getScheduleId() != null) {
                return context.getResourceId() + "," + summary.getScheduleId().toString();
            }
            throw new IllegalStateException("MetricsDisplayMode was 'RESOURCE', but the scheduleId was null");
        }
        if (context.type == EntityContext.Type.ResourceGroup) {
            return "cg," + context.getGroupId() + "," + summary.getDefinitionId();
        }
        if (context.type == EntityContext.Type.AutoGroup) {
            return "ag," + context.getParentResourceId() + "," + summary.getDefinitionId() + "," + context.getResourceTypeId();
        }
        throw new IllegalArgumentException("Unknown or unsupported context '" + context + "'");
    }

    private void storeMetricsInSession(HttpServletRequest request, List<MetricDisplaySummary> metrics, IndicatorViewsForm form) throws ServletException, SessionTimeoutException, SessionNotFoundException {
        request.setAttribute("chartDataKeys", metrics);
        String[] scheduleIds = new String[metrics.size()];
        int i = 0;
        for (MetricDisplaySummary summary : metrics) {
            scheduleIds[i++] = this.getContextKeyChart(summary);
        }
        form.setMetric(scheduleIds);
        EntityContext context = new EntityContext(form.getId(), Integer.valueOf(form.getGroupId()), Integer.valueOf(form.getParent()), form.getCtype());
        String key = context.getLegacyKey() + "." + form.getView();
        HttpSession session = request.getSession();
        session.setAttribute(key, metrics);
        session.setAttribute("metricKey", (Object)key);
        this.storeMetricsInUserPreferences(request, metrics, form);
    }

    private List<MetricDisplaySummary> retrieveMetricsFromSession(HttpServletRequest request, IndicatorViewsForm form) throws SessionNotFoundException, SessionTimeoutException, PermissionException, ServletException {
        List<Object> metrics;
        block7: {
            metrics = new ArrayList<MetricDisplaySummary>();
            Subject subject = WebUtility.getSubject((HttpServletRequest)request);
            try {
                String viewName = form.getView();
                EntityContext context = null;
                try {
                    context = new EntityContext(form.getId(), Integer.valueOf(form.getGroupId()), Integer.valueOf(form.getParent()), form.getCtype());
                }
                catch (IllegalArgumentException iae) {
                    context = WebUtility.getEntityContext();
                }
                if (context.type == EntityContext.Type.Resource) {
                    metrics = this.chartsManager.getMetricDisplaySummariesForResource(subject, context.resourceId, viewName);
                    break block7;
                }
                if (context.type == EntityContext.Type.ResourceGroup) {
                    metrics = this.chartsManager.getMetricDisplaySummariesForCompatibleGroup(subject, context.groupId, viewName);
                    break block7;
                }
                if (context.type == EntityContext.Type.AutoGroup) {
                    metrics = this.chartsManager.getMetricDisplaySummariesForAutoGroup(subject, context.parentResourceId, context.resourceTypeId, viewName);
                    break block7;
                }
                throw new IllegalArgumentException("Unknown or unsupported context: " + context);
            }
            catch (Exception e) {
                log.error((Object)"Error loading metrics (they were not found in the session)", (Throwable)e);
            }
        }
        return metrics;
    }

    public ActionForward fresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)("Calling " + IndicatorChartsUIBean.class.getSimpleName() + " fresh"));
        HttpSession session = request.getSession();
        WebUser user = SessionUtils.getWebUser((HttpSession)session);
        IndicatorViewsForm ivf = (IndicatorViewsForm)form;
        String viewName = ivf.getView();
        List metrics = new ArrayList();
        EntityContext context = WebUtility.getEntityContext((HttpServletRequest)request);
        try {
            List charts = this.viewManager.getCharts(user.getSubject(), context, viewName);
            for (String token : charts) {
                MetricDisplaySummary tmp = MeasurementUtils.parseMetricToken((String)token);
                metrics.add(tmp);
            }
            metrics = this.reloadMetrics(request, metrics, true);
            this.storeMetricsInSession(request, metrics, ivf);
            return mapping.findForward("success");
        }
        catch (MeasurementViewException mve) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error getting charts: " + mve.getMessage()));
            }
            if (context.type == EntityContext.Type.Resource) {
                metrics = this.chartsManager.getMetricDisplaySummariesForResource(user.getSubject(), context.resourceId, viewName);
                for (MetricDisplaySummary summary : metrics) {
                    summary.setMetricToken(this.getContextKeyChart(summary));
                    MonitorUtils.formatSimpleMetrics((MetricDisplaySummary)summary, null);
                }
            } else if (context.type == EntityContext.Type.ResourceGroup) {
                metrics = this.chartsManager.getMetricDisplaySummariesForCompatibleGroup(user.getSubject(), context.groupId, viewName);
                for (MetricDisplaySummary summary : metrics) {
                    summary.setMetricToken(this.getContextKeyChart(summary));
                    MonitorUtils.formatSimpleMetrics((MetricDisplaySummary)summary, null);
                }
                request.setAttribute("chartDataKeys", metrics);
            } else if (context.type == EntityContext.Type.AutoGroup) {
                metrics = this.chartsManager.getMetricDisplaySummariesForAutoGroup(user.getSubject(), context.parentResourceId, context.resourceTypeId, viewName);
                for (MetricDisplaySummary summary : metrics) {
                    summary.setMetricToken(this.getContextKeyChart(summary));
                    MonitorUtils.formatSimpleMetrics((MetricDisplaySummary)summary, null);
                }
                request.setAttribute("chartDataKeys", metrics);
            }
            this.storeMetricsInSession(request, metrics, ivf);
            return mapping.findForward("success");
        }
    }

    private List<MetricDisplaySummary> reloadMetrics(HttpServletRequest request, List<MetricDisplaySummary> metrics, boolean force) {
        HttpSession session = request.getSession();
        WebUser user = SessionUtils.getWebUser((HttpSession)session);
        MeasurementPreferences preferences = user.getMeasurementPreferences();
        MeasurementPreferences.MetricRangePreferences rangePreferences = preferences.getMetricRangePreferences();
        long begin = rangePreferences.begin;
        long end = rangePreferences.end;
        ArrayList<MetricDisplaySummary> ret = new ArrayList<MetricDisplaySummary>(metrics.size());
        Locale userLocale = request.getLocale();
        for (MetricDisplaySummary sum : metrics) {
            List tmpList;
            MetricsDisplayMode mode = this.getDisplayModeForSummary(sum);
            switch (1.$SwitchMap$org$rhq$enterprise$gui$util$MetricsDisplayMode[mode.ordinal()]) {
                case 1: {
                    tmpList = this.chartsManager.getMetricDisplaySummariesForResource(user.getSubject(), sum.getResourceId(), new int[]{sum.getScheduleId()}, begin, end);
                    break;
                }
                case 3: {
                    tmpList = this.chartsManager.getMetricDisplaySummariesForAutoGroup(user.getSubject(), sum.getParentId(), sum.getChildTypeId(), new int[]{sum.getDefinitionId()}, begin, end, false);
                    break;
                }
                case 2: {
                    tmpList = this.chartsManager.getMetricDisplaySummariesForCompatibleGroup(user.getSubject(), sum.getGroupId(), new int[]{sum.getDefinitionId()}, begin, end, false);
                    break;
                }
                default: {
                    tmpList = null;
                }
            }
            if (tmpList != null && tmpList.size() > 0) {
                MetricDisplaySummary tmp = (MetricDisplaySummary)tmpList.get(0);
                tmp.setMetricToken(this.getContextKeyChart(tmp));
                if (tmp.getMetricKeys().length > 0) {
                    MonitorUtils.formatSimpleMetrics((MetricDisplaySummary)tmp, (Locale)userLocale);
                }
                ret.add(tmp);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("We did not get a result back for " + sum));
        }
        return ret;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)("Calling " + IndicatorChartsUIBean.class.getSimpleName() + " refresh"));
        IndicatorViewsForm ivf = (IndicatorViewsForm)form;
        List metrics = this.retrieveMetricsFromSession(request, ivf);
        metrics = this.reloadMetrics(request, metrics, false);
        this.storeMetricsInSession(request, metrics, ivf);
        return mapping.findForward("success");
    }

    public ActionForward add(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)("Calling " + IndicatorChartsUIBean.class.getSimpleName() + " add"));
        IndicatorViewsForm ivf = (IndicatorViewsForm)form;
        List metrics = this.retrieveMetricsFromSession(request, ivf);
        if (metrics == null) {
            return mapping.findForward("failure");
        }
        String newMetric = ivf.getAddMetric();
        MetricDisplaySummary newSummary = MeasurementUtils.parseMetricToken((String)newMetric);
        MetricsDisplayMode mode = this.getDisplayModeForSummary(newSummary);
        boolean found = false;
        block10: for (MetricDisplaySummary metric : metrics) {
            Integer definitionId = metric.getDefinitionId();
            switch (1.$SwitchMap$org$rhq$enterprise$gui$util$MetricsDisplayMode[mode.ordinal()]) {
                case 1: {
                    Integer schedId = metric.getScheduleId();
                    if (schedId == null || !schedId.equals(newSummary.getScheduleId())) continue block10;
                    found = true;
                    continue block10;
                }
                case 2: {
                    if (metric.getGroupId() != newSummary.getGroupId() || definitionId != newSummary.getDefinitionId()) continue block10;
                    found = true;
                    continue block10;
                }
                case 3: {
                    int parent = metric.getParentId();
                    int type = metric.getChildTypeId();
                    if (parent != newSummary.getParentId() || type != newSummary.getChildTypeId() || definitionId != newSummary.getDefinitionId()) continue block10;
                    found = true;
                    continue block10;
                }
            }
            throw new IllegalArgumentException(mode + " not valid here");
        }
        List newSummaries = new ArrayList();
        if (!found) {
            WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
            MeasurementPreferences preferences = user.getMeasurementPreferences();
            MeasurementPreferences.MetricRangePreferences rangePreferences = preferences.getMetricRangePreferences();
            long begin = rangePreferences.begin;
            long end = rangePreferences.end;
            switch (1.$SwitchMap$org$rhq$enterprise$gui$util$MetricsDisplayMode[mode.ordinal()]) {
                case 1: {
                    newSummaries = this.chartsManager.getMetricDisplaySummariesForResource(user.getSubject(), newSummary.getResourceId(), new int[]{newSummary.getScheduleId()}, begin, end);
                    break;
                }
                case 2: {
                    newSummaries = this.chartsManager.getMetricDisplaySummariesForCompatibleGroup(user.getSubject(), newSummary.getGroupId(), new int[]{newSummary.getDefinitionId()}, begin, end, false);
                    break;
                }
                case 3: {
                    newSummaries = this.chartsManager.getMetricDisplaySummariesForAutoGroup(user.getSubject(), newSummary.getParentId(), newSummary.getChildTypeId(), new int[]{newSummary.getDefinitionId()}, begin, end, false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(mode + " not valid here");
                }
            }
        }
        metrics.addAll(newSummaries);
        this.storeMetricsInSession(request, metrics, ivf);
        return this.refresh(mapping, form, request, response);
    }

    public ActionForward remove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)("Calling " + IndicatorChartsUIBean.class.getSimpleName() + " remove"));
        IndicatorViewsForm ivf = (IndicatorViewsForm)form;
        Subject subject = WebUtility.getSubject((HttpServletRequest)request);
        EntityContext context = new EntityContext(ivf.getId(), Integer.valueOf(ivf.getGroupId()), Integer.valueOf(ivf.getParent()), ivf.getCtype());
        this.viewManager.removeChart(subject, context, ivf.getView(), ivf.getMetric()[0]);
        List metrics = this.retrieveMetricsFromSession(request, ivf);
        this.storeMetricsInSession(request, metrics, ivf);
        return mapping.findForward("ajax");
    }

    public ActionForward moveUp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)("Calling " + IndicatorChartsUIBean.class.getSimpleName() + " moveUp"));
        IndicatorViewsForm ivf = (IndicatorViewsForm)form;
        Subject subject = WebUtility.getSubject((HttpServletRequest)request);
        EntityContext context = new EntityContext(ivf.getId(), Integer.valueOf(ivf.getGroupId()), Integer.valueOf(ivf.getParent()), ivf.getCtype());
        this.viewManager.moveChartUp(subject, context, ivf.getView(), ivf.getMetric()[0]);
        List metrics = this.retrieveMetricsFromSession(request, ivf);
        this.storeMetricsInSession(request, metrics, ivf);
        return mapping.findForward("ajax");
    }

    public ActionForward moveDown(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)("Calling " + IndicatorChartsUIBean.class.getSimpleName() + " moveDown"));
        IndicatorViewsForm ivf = (IndicatorViewsForm)form;
        Subject subject = WebUtility.getSubject((HttpServletRequest)request);
        EntityContext context = new EntityContext(ivf.getId(), Integer.valueOf(ivf.getGroupId()), Integer.valueOf(ivf.getParent()), ivf.getCtype());
        this.viewManager.moveChartDown(subject, context, ivf.getView(), ivf.getMetric()[0]);
        List metrics = this.retrieveMetricsFromSession(request, ivf);
        this.storeMetricsInSession(request, metrics, ivf);
        return mapping.findForward("ajax");
    }

    public ActionForward go(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)("Calling " + IndicatorChartsUIBean.class.getSimpleName() + " go"));
        return mapping.findForward("currentHealth");
    }

    private static int indexOfSpecialChars(String aTagFragment) {
        StringCharacterIterator iterator = new StringCharacterIterator(aTagFragment);
        int i = 0;
        char character = iterator.current();
        while (character != '\uffff') {
            switch (character) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    return i;
                }
            }
            character = iterator.next();
            ++i;
        }
        return -1;
    }

    public ActionForward create(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)("Calling " + IndicatorChartsUIBean.class.getSimpleName() + " create"));
        IndicatorViewsForm ivf = (IndicatorViewsForm)form;
        WebUser user = SessionUtils.getWebUser((HttpSession)request.getSession());
        MeasurementPreferences preferences = user.getMeasurementPreferences();
        String newViewName = ivf.getView();
        if (newViewName.length() == 0) {
            RequestUtils.setError((HttpServletRequest)request, (String)"resource.common.monitor.visibility.view.error.empty");
            return mapping.findForward("currentHealth");
        }
        if (IndicatorChartsUIBean.indexOfSpecialChars((String)newViewName) > -1) {
            RequestUtils.setError((HttpServletRequest)request, (String)"error.input.badchars");
            return mapping.findForward("currentHealth");
        }
        EntityContext context = new EntityContext(ivf.getId(), Integer.valueOf(ivf.getGroupId()), Integer.valueOf(ivf.getParent()), ivf.getCtype());
        try {
            this.viewManager.createView(user.getSubject(), context, newViewName);
        }
        catch (MeasurementViewException mve) {
            RequestUtils.setError((HttpServletRequest)request, (String)"resource.common.monitor.visibility.view.error.exists");
            return mapping.findForward("currentHealth");
        }
        List viewNames = this.viewManager.getViewNames(user.getSubject(), context);
        ivf.setViews(viewNames.toArray(new String[viewNames.size()]));
        return this.update(mapping, (ActionForm)ivf, request, response);
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)("Calling " + IndicatorChartsUIBean.class.getSimpleName() + " update"));
        this.refresh(mapping, form, request, response);
        return mapping.findForward("currentHealth");
    }

    private void storeMetricsInUserPreferences(HttpServletRequest request, List<MetricDisplaySummary> metrics, IndicatorViewsForm ivf) throws SessionNotFoundException, SessionTimeoutException, ServletException {
        MeasurementPreferences.MetricViewData data = new MeasurementPreferences.MetricViewData();
        data.charts = new ArrayList();
        for (MetricDisplaySummary mds : metrics) {
            String chart = this.getContextKeyChart(mds);
            data.charts.add(chart);
        }
        Subject subject = WebUtility.getSubject((HttpServletRequest)request);
        EntityContext context = new EntityContext(ivf.getId(), Integer.valueOf(ivf.getGroupId()), Integer.valueOf(ivf.getParent()), ivf.getCtype());
        this.viewManager.saveCharts(subject, context, ivf.getView(), data.charts);
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)("Calling " + IndicatorChartsUIBean.class.getSimpleName() + " delete"));
        IndicatorViewsForm ivf = (IndicatorViewsForm)form;
        Subject subject = WebUtility.getSubject((HttpServletRequest)request);
        String doomedView = ivf.getUpdate();
        EntityContext context = new EntityContext(ivf.getId(), Integer.valueOf(ivf.getGroupId()), Integer.valueOf(ivf.getParent()), ivf.getCtype());
        this.viewManager.deleteView(subject, context, doomedView);
        return mapping.findForward("currentHealth");
    }

    private MetricsDisplayMode getDisplayModeForSummary(MetricDisplaySummary summary) {
        if (summary.getResourceId() > 0) {
            return MetricsDisplayMode.RESOURCE;
        }
        if (summary.getGroupId() > 0) {
            return MetricsDisplayMode.COMPGROUP;
        }
        if (summary.getParentId() > 0 && summary.getChildTypeId() > 0) {
            return MetricsDisplayMode.AUTOGROUP;
        }
        log.debug((Object)("Mode could not be determined for " + summary));
        return MetricsDisplayMode.UNSET;
    }

    public String processAction() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        HttpServletRequest request = FacesContextUtility.getRequest();
        EntityContext context = WebUtility.getEntityContext((HttpServletRequest)request);
        String action = WebUtility.getOptionalRequestParameter((ServletRequest)request, (String)"action", null);
        String viewName = WebUtility.getOptionalRequestParameter((ServletRequest)request, (String)"view", null);
        if (action != null) {
            if (action.equals("create")) {
                try {
                    if (viewName != null && !viewName.equals("")) {
                        this.viewManager.createView(subject, context, viewName);
                        this.viewManager.setSelectedView(subject, context, viewName);
                    }
                }
                catch (MeasurementViewException mve) {}
            } else if (action.equals("delete")) {
                try {
                    this.viewManager.deleteView(subject, context, this.view);
                }
                catch (Exception e) {
                    log.error((Object)("Error deleting view " + this.view + " for " + context.toShortString()), (Throwable)e);
                }
                List remainingViews = this.viewManager.getViewNames(subject, context);
                String newSelectedView = (String)remainingViews.get(0);
                this.viewManager.setSelectedView(subject, context, newSelectedView);
                this.view = newSelectedView;
            } else if (action.equals("go")) {
                this.viewManager.setSelectedView(subject, context, viewName);
            }
        }
        return "success";
    }
}

