/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.operation.definition;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class OperationDefinitionParametersUIBean {
    public static final String MANAGED_BEAN_NAME = "OperationDefinitionParametersUIBean";
    private Configuration configuration;
    private ConfigurationDefinition configurationDefinition;
    private OperationManagerLocal operationManager = LookupUtil.getOperationManager();
    private ConfigurationManagerLocal configurationManager = LookupUtil.getConfigurationManager();

    public OperationDefinitionParametersUIBean() {
        this.configurationDefinition = this.lookupConfigurationDefinition();
        this.configuration = this.lookupConfiguration();
    }

    @Nullable
    public ConfigurationDefinition getConfigurationDefinition() {
        return this.configurationDefinition;
    }

    public void setConfigurationDefinition(@NotNull ConfigurationDefinition configurationDefinition) {
        this.configurationDefinition = configurationDefinition;
    }

    @Nullable
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(@NotNull Configuration configuration) {
        this.configuration = configuration;
    }

    protected Configuration lookupConfiguration() {
        try {
            ConfigurationDefinition definition = this.lookupConfigurationDefinition();
            Configuration configuration = this.configurationManager.getConfigurationFromDefaultTemplate(definition);
            Configuration newConfiguration = configuration.deepCopy(false);
            return newConfiguration;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected ConfigurationDefinition lookupConfigurationDefinition() {
        try {
            Subject subject = EnterpriseFacesContextUtility.getSubject();
            int operationId = Integer.valueOf(FacesContextUtility.getRequiredRequestParameter((String)"opId"));
            OperationDefinition operationDefinition = this.operationManager.getOperationDefinition(subject, operationId);
            ConfigurationDefinition definition = operationDefinition.getParametersConfigurationDefinition();
            return definition;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getNullConfigurationDefinitionMessage() {
        return "This operation does not take any parameters.";
    }

    public String getNullConfigurationMessage() {
        return "This operation parameters definition has not been initialized.";
    }
}

