/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.gui.operation.schedule.group;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.composite.IntegerOptionItem;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.operation.bean.GroupOperationSchedule;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.enterprise.gui.operation.definition.group.ResourceGroupOperationDefinitionUIBean;
import org.rhq.enterprise.gui.operation.schedule.OperationScheduleUIBean;
import org.rhq.enterprise.gui.util.EnterpriseFacesContextUtility;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.QuartzUtil;

public class ResourceGroupOperationScheduleUIBean
extends OperationScheduleUIBean {
    private ResourceGroup group;

    public String getManagedBeanName() {
        return "ResourceGroupOperationScheduleUIBean";
    }

    public List<GroupOperationSchedule> getOperationScheduleList() {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        ResourceGroup requestGroup = EnterpriseFacesContextUtility.getResourceGroup();
        if (requestGroup == null) {
            requestGroup = this.group;
        } else {
            this.group = requestGroup;
        }
        List results = null;
        try {
            results = this.manager.findScheduledGroupOperations(subject, requestGroup.getId());
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return results;
    }

    public void unscheduleOperation(Subject subject, String doomedJobId) throws Exception {
        if (this.group == null) {
            this.group = EnterpriseFacesContextUtility.getResourceGroup();
            if (this.group == null) {
                throw new IllegalStateException("Could not find resource group from which to delete operation schedules");
            }
        }
        this.manager.unscheduleGroupOperation(subject, doomedJobId, this.group.getId());
    }

    public String executeNow() throws Exception {
        Subject subject = EnterpriseFacesContextUtility.getSubject();
        HttpServletRequest request = FacesContextUtility.getRequest();
        String[] selectedItems = request.getParameterValues("selectedItems");
        if (selectedItems == null || selectedItems.length == 0) {
            selectedItems = request.getParameterValues("jobId");
        }
        if (selectedItems == null || selectedItems.length == 0) {
            throw new IllegalStateException("No job selected to execute");
        }
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        for (String jobIdString : selectedItems) {
            int[] resourceIds;
            GroupOperationSchedule groupSchedule;
            try {
                groupSchedule = this.manager.getGroupOperationSchedule(subject, jobIdString);
            }
            catch (SchedulerException se) {
                throw new IllegalStateException(se.getMessage(), se);
            }
            List resources = groupSchedule.getExecutionOrder();
            if (resources == null) {
                resourceIds = new int[]{};
            } else {
                resourceIds = new int[resources.size()];
                int i = 0;
                for (Resource next : resources) {
                    resourceIds[i++] = next.getId();
                }
            }
            JobDetail jobDetail = scheduler.getJobDetail(groupSchedule.getJobName(), groupSchedule.getJobGroup());
            this.scheduleOperation(subject, groupSchedule.getOperationName(), resourceIds, groupSchedule.isHaltOnFailure(), groupSchedule.getParameters(), (SimpleTrigger)QuartzUtil.getFireOnceImmediateTrigger((JobDetail)jobDetail), groupSchedule.getDescription());
        }
        return "viewOperationHistory";
    }

    public void scheduleOperation(Subject subject, String operationName, Configuration parameters, SimpleTrigger simpleTrigger, String description) throws Exception {
        ResourceGroupOperationDefinitionUIBean bean = (ResourceGroupOperationDefinitionUIBean)FacesContextUtility.getBean(ResourceGroupOperationDefinitionUIBean.class);
        this.scheduleOperation(subject, operationName, this.getResourceIds(), bean.isHaltOnFailure(), parameters, simpleTrigger, description);
    }

    private void scheduleOperation(Subject subject, String operationName, int[] passedResourceIds, boolean haltOnFailure, Configuration parameters, SimpleTrigger simpleTrigger, String description) throws Exception {
        if (this.group == null) {
            this.group = EnterpriseFacesContextUtility.getResourceGroup();
            if (this.group == null) {
                throw new IllegalStateException("Could not find resource group against which to schedule operations");
            }
        }
        this.manager.scheduleGroupOperation(subject, this.group.getId(), passedResourceIds, haltOnFailure, operationName, parameters, (Trigger)simpleTrigger, description);
    }

    public int[] getResourceIds() {
        ResourceGroupOperationDefinitionUIBean operationDefinitionUIBean = (ResourceGroupOperationDefinitionUIBean)FacesContextUtility.getBean(ResourceGroupOperationDefinitionUIBean.class);
        if (operationDefinitionUIBean.isConcurrent()) {
            return null;
        }
        List orderedNameItems = operationDefinitionUIBean.getResourceNameItems();
        int i = 0;
        int[] resourceIds = new int[orderedNameItems.size()];
        for (IntegerOptionItem nameItem : orderedNameItems) {
            resourceIds[i++] = (Integer)nameItem.getId();
        }
        return resourceIds;
    }
}

