/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.perspective;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PerspectiveTarget {
    AGENT("/rhq/ha/viewAgent.xhtml?mode=view&agentId="),
    ALERT("/alerts/Alerts.do?mode=viewAlert&a=", true, false),
    ALERT_DEFINITION("/alerts/Config.do?mode=viewRoles&ad=", true, false),
    ALERT_TEMPLATE("/alerts/Config.do?mode=viewRoles&ad=", false, true),
    CONTENT_PROVIDER("/rhq/content/contentProvider.xhtml?mode=view&id="),
    GROUP_COMPATIBLE("/rhq/group/monitor/graphs.xhtml?category=COMPATIBLE&groupId="),
    GROUP_DEFINITION("/rhq/definition/group/view.xhtml?groupDefinitionId="),
    GROUP_MIXED("/rhq/group/inventory/view.xhtml?category=MIXED&groupId="),
    METRIC_TEMPLATE("/admin/platform/monitor/Config.do?mode=configure&id=", false, true),
    REPO("/rhq/content/repo.xhtml?mode=view&id="),
    RESOURCE("/rhq/resource/summary/overview.xhtml?id="),
    ROLE("/admin/role/RoleAdmin.do?mode=view&r="),
    SERVER("/rhq/ha/viewServer.xhtml?mode=view&serverId="),
    USER("/admin/user/UserAdmin.do?mode=view&u=");

    private final String baseUrl;
    private final boolean isResourceTarget;
    private final boolean isTemplateTarget;

    private PerspectiveTarget(String baseUrl) {
        this(baseUrl, false, false);
    }

    private PerspectiveTarget(String baseUrl, boolean isResourceTarget, boolean isTemplateTarget) {
        this.baseUrl = baseUrl;
        this.isResourceTarget = isResourceTarget;
        this.isTemplateTarget = isTemplateTarget;
    }

    public String getTargetUrl(int targetId) {
        if (this.isResourceTarget || this.isTemplateTarget) {
            throw new IllegalArgumentException("This PerspectiveTarget requires resource or resource type information, use appropriate getter: " + (Object)((Object)this));
        }
        return this.baseUrl + targetId;
    }

    public String getResourceTargetUrl(int resourceId, int targetId) {
        if (!this.isResourceTarget) {
            throw new IllegalArgumentException("This is not a resource qualified PerspectiveTarget. Use appropriate getter: " + (Object)((Object)this));
        }
        return this.baseUrl + targetId + "&id=" + resourceId;
    }

    public String getTemplateTargetUrl(int resourceTypeId, int targetId) {
        if (!this.isTemplateTarget) {
            throw new IllegalArgumentException("This is not a template PerspectiveTarget. Use appropriate getter: " + (Object)((Object)this));
        }
        return this.baseUrl + targetId + "&type=" + resourceTypeId;
    }

    public boolean isResourceTarget() {
        return this.isResourceTarget;
    }

    public boolean isTemplateTarget() {
        return this.isTemplateTarget;
    }
}

