/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class Assert {
    protected Assert() {
    }

    public static void assertTrue(boolean condition, String message) {
        if (!condition) {
            Assert.failNotEquals(condition, Boolean.TRUE, message);
        }
    }

    public static void assertTrue(boolean condition) {
        Assert.assertTrue(condition, null);
    }

    public static void assertFalse(boolean condition, String message) {
        if (condition) {
            Assert.failNotEquals(condition, Boolean.FALSE, message);
        }
    }

    public static void assertFalse(boolean condition) {
        Assert.assertFalse(condition, null);
    }

    public static void fail(String message, Throwable realCause) {
        AssertionError ae = new AssertionError((Object)message);
        ((Throwable)((Object)ae)).initCause(realCause);
        throw ae;
    }

    public static void fail(String message) {
        throw new AssertionError((Object)message);
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void assertEquals(Object actual, Object expected, String message) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        Assert.failNotEquals(actual, expected, message);
    }

    public static void assertEquals(Object actual, Object expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(String actual, String expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(String actual, String expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(double actual, double expected, double delta, String message) {
        if (Double.isInfinite(expected)) {
            if (expected != actual) {
                Assert.failNotEquals(new Double(actual), new Double(expected), message);
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            Assert.failNotEquals(new Double(actual), new Double(expected), message);
        }
    }

    public static void assertEquals(double actual, double expected, double delta) {
        Assert.assertEquals(actual, expected, delta, null);
    }

    public static void assertEquals(float actual, float expected, float delta, String message) {
        if (Float.isInfinite(expected)) {
            if (expected != actual) {
                Assert.failNotEquals(new Float(actual), new Float(expected), message);
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            Assert.failNotEquals(new Float(actual), new Float(expected), message);
        }
    }

    public static void assertEquals(float actual, float expected, float delta) {
        Assert.assertEquals(actual, expected, delta, null);
    }

    public static void assertEquals(long actual, long expected, String message) {
        Assert.assertEquals(new Long(actual), new Long(expected), message);
    }

    public static void assertEquals(long actual, long expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(boolean actual, boolean expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(boolean actual, boolean expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(byte actual, byte expected, String message) {
        Assert.assertEquals(new Byte(actual), new Byte(expected), message);
    }

    public static void assertEquals(byte actual, byte expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(char actual, char expected, String message) {
        Assert.assertEquals(new Character(actual), new Character(expected), message);
    }

    public static void assertEquals(char actual, char expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(short actual, short expected, String message) {
        Assert.assertEquals(new Short(actual), new Short(expected), message);
    }

    public static void assertEquals(short actual, short expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(int actual, int expected, String message) {
        Assert.assertEquals(new Integer(actual), new Integer(expected), message);
    }

    public static void assertEquals(int actual, int expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull(object, null);
    }

    public static void assertNotNull(Object object, String message) {
        Assert.assertTrue(object != null, message);
    }

    public static void assertNull(Object object) {
        Assert.assertNull(object, null);
    }

    public static void assertNull(Object object, String message) {
        Assert.assertTrue(object == null, message);
    }

    public static void assertSame(Object actual, Object expected, String message) {
        if (expected == actual) {
            return;
        }
        Assert.failNotSame(actual, expected, message);
    }

    public static void assertSame(Object actual, Object expected) {
        Assert.assertSame(actual, expected, null);
    }

    public static void assertNotSame(Object actual, Object expected, String message) {
        if (expected == actual) {
            Assert.failSame(actual, expected, message);
        }
    }

    public static void assertNotSame(Object actual, Object expected) {
        Assert.assertNotSame(actual, expected, null);
    }

    private static void failSame(Object actual, Object expected, String message) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + "expected not same with:<" + expected + "> but was same:<" + actual + ">");
    }

    private static void failNotSame(Object actual, Object expected, String message) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + "expected same with:<" + expected + "> but was:<" + actual + ">");
    }

    private static void failNotEquals(Object actual, Object expected, String message) {
        Assert.fail(Assert.format(actual, expected, message));
    }

    static String format(Object actual, Object expected, String message) {
        String formatted = "";
        if (null != message) {
            formatted = message + " ";
        }
        return formatted + "expected:<" + expected + "> but was:<" + actual + ">";
    }

    public static void assertEquals(Collection actual, Collection expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Collection actual, Collection expected, String message) {
        if (actual == expected) {
            return;
        }
        if (actual == null && expected != null || actual != null && expected == null) {
            if (message != null) {
                Assert.fail(message);
            } else {
                Assert.fail("Arrays not equal: " + expected + " and " + actual);
            }
        }
        Assert.assertEquals(actual.size(), expected.size(), message + ": lists don't have the same size");
        Iterator actIt = actual.iterator();
        Iterator expIt = expected.iterator();
        int i = -1;
        while (actIt.hasNext() && expIt.hasNext()) {
            Object e = expIt.next();
            Object a = actIt.next();
            String errorMessage = message == null ? "Lists differ at element [" + i + "]: " + e + " != " + a : message + ": Lists differ at element [" + ++i + "]: " + e + " != " + a;
            Assert.assertEquals(a, e, errorMessage);
        }
    }

    public static void assertEquals(Object[] actual, Object[] expected, String message) {
        if (actual == expected) {
            return;
        }
        if (actual == null && expected != null || actual != null && expected == null) {
            if (message != null) {
                Assert.fail(message);
            } else {
                Assert.fail("Arrays not equal: " + expected + " and " + actual);
            }
        }
        Assert.assertEquals(Arrays.asList(actual), Arrays.asList(expected), message);
    }

    public static void assertEqualsNoOrder(Object[] actual, Object[] expected, String message) {
        if (actual == expected) {
            return;
        }
        if (actual == null && expected != null || actual != null && expected == null) {
            Assert.failAssertNoEqual(actual, expected, "Arrays not equal: " + expected + " and " + actual, message);
        }
        if (actual.length != expected.length) {
            Assert.failAssertNoEqual(actual, expected, "Arrays do not have the same size:" + actual.length + " != " + expected.length, message);
        }
        ArrayList<Object> actualCollection = new ArrayList<Object>();
        for (Object a : actual) {
            actualCollection.add(a);
        }
        for (Object o : expected) {
            actualCollection.remove(o);
        }
        if (actualCollection.size() != 0) {
            Assert.failAssertNoEqual(actual, expected, "Arrays not equal: " + expected + " and " + actual, message);
        }
    }

    private static void failAssertNoEqual(Object[] actual, Object[] expected, String message, String defaultMessage) {
        if (message != null) {
            Assert.fail(message);
        } else {
            Assert.fail(defaultMessage);
        }
    }

    public static void assertEquals(Object[] actual, Object[] expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEqualsNoOrder(Object[] actual, Object[] expected) {
        Assert.assertEqualsNoOrder(actual, expected, null);
    }

    public static void assertEquals(byte[] actual, byte[] expected) {
        Assert.assertEquals(actual, expected, "");
    }

    public static void assertEquals(byte[] actual, byte[] expected, String message) {
        if (expected == actual) {
            return;
        }
        if (null == expected) {
            Assert.fail("expected a null array, but not null found. " + message);
        }
        if (null == actual) {
            Assert.fail("expected not null array, but null found. " + message);
        }
        Assert.assertEquals(actual.length, expected.length, "arrays don't have the same size. " + message);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assert.fail("arrays differ firstly at element [" + i + "]; " + "expected value is <" + expected[i] + "> but was <" + actual[i] + ">. " + message);
        }
    }
}

