/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client;

import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class Version {
    public static final String PROP_PRODUCT_NAME = "Implementation-Title";
    public static final String PROP_PRODUCT_VERSION = "Implementation-Version";
    public static final String PROP_BUILD_NUMBER = "Build-Number";
    public static final String PROP_BUILD_DATE = "Build-Time";
    public static final String PROP_BUILD_JDK_VENDOR = "Java-Vendor";
    public static final String PROP_BUILD_JDK_VERSION = "Java-Version";
    public static final String PROP_BUILD_OS_NAME = "Os-Name";
    public static final String PROP_BUILD_OS_VERSION = "Os-Version";
    private static Properties propertiesCache = null;

    public static void main(String[] args) {
        System.out.println("==========");
        if (args.length == 0) {
            System.out.println(Version.getVersionPropertiesAsString());
        } else {
            Properties props = Version.getVersionProperties();
            for (int i = 0; i < args.length; ++i) {
                String key = args[i];
                String value = props.getProperty(key);
                if (value == null) {
                    value = "<unknown>";
                }
                System.out.println(key + "=" + value);
            }
        }
        System.out.println("==========");
    }

    public static String getProductNameAndVersion() {
        Properties props = Version.getVersionProperties();
        String name = props.getProperty(PROP_PRODUCT_NAME);
        String version = props.getProperty(PROP_PRODUCT_VERSION);
        return name + ' ' + version;
    }

    public static String getProductNameAndVersionBuildInfo() {
        Properties props = Version.getVersionProperties();
        String name = props.getProperty(PROP_PRODUCT_NAME);
        String version = props.getProperty(PROP_PRODUCT_VERSION);
        String buildNum = props.getProperty(PROP_BUILD_NUMBER);
        String buildDate = props.getProperty(PROP_BUILD_DATE);
        return name + ' ' + version + " (" + buildNum + ") " + buildDate;
    }

    public static String getProductName() {
        Properties props = Version.getVersionProperties();
        String name = props.getProperty(PROP_PRODUCT_NAME);
        return name;
    }

    public static String getProductVersion() {
        Properties props = Version.getVersionProperties();
        String version = props.getProperty(PROP_PRODUCT_VERSION);
        return version;
    }

    public static String getBuildDate() {
        Properties props = Version.getVersionProperties();
        String build_date = props.getProperty(PROP_BUILD_DATE);
        return build_date;
    }

    public static String getBuildNumber() {
        Properties props = Version.getVersionProperties();
        String build_num = props.getProperty(PROP_BUILD_NUMBER);
        return build_num;
    }

    public static Properties getVersionProperties() {
        if (propertiesCache == null) {
            Manifest manifest;
            try {
                URL jarUrl = Version.class.getProtectionDomain().getCodeSource().getLocation();
                JarFile jarFile = new JarFile(new File(jarUrl.toURI()));
                manifest = jarFile.getManifest();
            }
            catch (Exception e) {
                return new Properties();
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            Properties newProps = new Properties();
            for (Map.Entry<Object, Object> entry : mainAttributes.entrySet()) {
                String name = entry.getKey().toString();
                String value = entry.getValue().toString();
                newProps.setProperty(name, value);
            }
            propertiesCache = newProps;
        }
        Properties retProps = new Properties();
        retProps.putAll((Map<?, ?>)propertiesCache);
        return retProps;
    }

    public static String getVersionPropertiesAsString() {
        Properties props = Version.getVersionProperties();
        StringBuilder str = new StringBuilder();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            str.append(entry.getKey().toString() + '=' + entry.getValue().toString() + '\n');
        }
        return str.toString();
    }
}

