/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client.export;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.rhq.enterprise.client.TabularWriter;
import org.rhq.enterprise.client.export.ExportException;

public class Exporter {
    private String format;
    private String file;
    private TabularWriter tabularWriter;
    private FileWriter fileWriter;

    public void setTarget(String format, String file) {
        try {
            this.format = format;
            this.file = file;
            this.fileWriter = new FileWriter(this.file);
            this.tabularWriter = new TabularWriter(new PrintWriter(this.fileWriter), format);
            this.tabularWriter.setExportMode(true);
        }
        catch (IOException e) {
            throw new ExportException(e);
        }
    }

    public int getPageWidth() {
        return this.tabularWriter.getWidth();
    }

    public void setPageWidth(int width) {
        this.tabularWriter.setWidth(width);
    }

    public void write(Object object) {
        try {
            this.tabularWriter.print(object);
            this.fileWriter.flush();
        }
        catch (IOException e) {
            throw new ExportException(e);
        }
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }
}

