/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client.utility;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageFinder {
    public List<String> findPackages(String packageRoot) {
        ArrayList<String> found = new ArrayList<String>();
        String cwd = System.getProperty("user.dir");
        File libDir = new File(cwd, "lib");
        File[] jars = libDir.exists() ? libDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".jar");
            }
        }) : this.loadJARsFromClassPath(packageRoot);
        for (File jar : jars) {
            this.findPackages(packageRoot, found, jar);
        }
        return found;
    }

    private File[] loadJARsFromClassPath(String pkgRoot) {
        try {
            ArrayList<File> jarFiles = new ArrayList<File>();
            String pkgPath = pkgRoot.replaceAll("\\.", "/");
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources(pkgPath);
            URL resource = null;
            while (resources.hasMoreElements()) {
                resource = resources.nextElement();
                if (!resource.toString().startsWith("jar:file")) continue;
                String jarFilePath = this.getJARFilePath(resource);
                jarFiles.add(new File(jarFilePath));
            }
            return jarFiles.toArray(new File[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new File[0];
        }
    }

    private String getJARFilePath(URL resource) {
        int startIndex = "jar:file:".length();
        String string = resource.toString().substring(startIndex);
        int endIndex = string.indexOf("!");
        return string.substring(0, endIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findPackages(String packageRoot, List<String> list, File jar) {
        HashSet<String> paths = new HashSet<String>();
        JarFile jf = null;
        try {
            jf = new JarFile(jar);
            String packagePath = packageRoot.replaceAll("\\.", "/");
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(packagePath)) continue;
                String match = entry.getName().substring(0, entry.getName().lastIndexOf("/"));
                paths.add(match.replaceAll("/", "\\."));
            }
            list.addAll(paths);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (jf != null) {
                    jf.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        new PackageFinder().findPackages("org.rhq.core.domain");
    }
}

