/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.client.utility;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public class ReflectionUtility {
    public static String getSimpleTypeString(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type[] typeArguments = pType.getActualTypeArguments();
            String typeArgString = "";
            for (Type typeArgument : typeArguments) {
                if (typeArgString.length() > 0) {
                    typeArgString = typeArgString + ",";
                }
                typeArgString = typeArgString + ReflectionUtility.getSimpleTypeString(typeArgument);
            }
            return ReflectionUtility.getSimpleTypeString(pType.getRawType()) + "<" + typeArgString + ">";
        }
        if (type instanceof TypeVariable) {
            TypeVariable vType = (TypeVariable)type;
            return vType.getClass().getSimpleName();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType aType = (GenericArrayType)type;
            return aType.getClass().getSimpleName() + "[" + ReflectionUtility.getSimpleTypeString(aType.getGenericComponentType()) + "]";
        }
        if (type instanceof WildcardType) {
            return ((WildcardType)type).toString();
        }
        if (type == null) {
            return "";
        }
        return ((Class)type).getSimpleName();
    }
}

