/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.client;

import java.io.Serializable;
import java.net.ConnectException;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import mazz.i18n.Logger;
import org.jboss.remoting.CannotConnectException;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.communications.command.Command;
import org.rhq.enterprise.communications.command.CommandResponse;
import org.rhq.enterprise.communications.command.client.ClientCommandSender;
import org.rhq.enterprise.communications.command.client.CommandAndCallback;
import org.rhq.enterprise.communications.command.impl.generic.GenericCommandResponse;
import org.rhq.enterprise.communications.command.impl.remotepojo.RemotePojoInvocationCommand;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientCommandSenderTask
implements Callable<CommandResponse>,
Runnable {
    private static final Logger LOG = CommI18NFactory.getLogger(ClientCommandSenderTask.class);
    private ClientCommandSender m_sender;
    private final CommandAndCallback m_cnc;
    private final long m_timeout;
    private final boolean m_isAsync;
    private final CommandResponse[] m_response;

    public ClientCommandSenderTask(ClientCommandSender sender, CommandAndCallback cnc, long timeout, boolean async, CommandResponse[] response) {
        this.m_sender = sender;
        this.m_cnc = cnc;
        this.m_timeout = timeout;
        this.m_isAsync = async;
        this.m_response = response;
    }

    @Override
    public CommandResponse call() throws Exception {
        CommandResponse response;
        try {
            response = this.send(this.m_sender, this.m_cnc);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
        return response;
    }

    @Override
    public void run() {
        CommandResponse response;
        boolean notify_callback;
        block17: {
            Command command = this.m_cnc.getCommand();
            notify_callback = this.m_cnc.getCallback() != null;
            try {
                this.m_sender.waitForSendThrottle(command);
                if (this.m_timeout > 0L) {
                    ThreadPoolExecutor timerThreadPool = this.m_sender.getTimerThreadPool();
                    if (timerThreadPool == null) {
                        throw new InterruptedException();
                    }
                    Future<CommandResponse> futureTask = timerThreadPool.submit(this);
                    try {
                        response = futureTask.get(this.m_timeout, TimeUnit.MILLISECONDS);
                        break block17;
                    }
                    catch (ExecutionException ee) {
                        throw ee.getCause();
                    }
                    catch (TimeoutException te) {
                        futureTask.cancel(true);
                        throw te;
                    }
                    catch (InterruptedException ie) {
                        futureTask.cancel(true);
                        throw ie;
                    }
                }
                response = this.call();
            }
            catch (Throwable t) {
                RemotePojoInvocationCommand rp;
                boolean isPing = false;
                if (command instanceof RemotePojoInvocationCommand && (rp = (RemotePojoInvocationCommand)command).getTargetInterfaceName().endsWith("Ping") && t instanceof CannotConnectException) {
                    isPing = true;
                }
                if (isPing) {
                    String agent = this.m_sender.getRemoteCommunicator().toString();
                    LOG.info("ClientCommandSenderTask.agent-ping-failed", new Object[]{agent});
                } else {
                    LOG.error(t, "ClientCommandSenderTask.send-failed", new Object[]{command, ThrowableUtil.getAllMessages((Throwable)t)});
                }
                response = new GenericCommandResponse(command, false, null, t);
                boolean retry = this.shouldCommandBeRetried(command, t);
                if (!retry) break block17;
                notify_callback = false;
                LOG.warn("ClientCommandSenderTask.queuing-failed-command", new Object[0]);
                try {
                    this.m_sender.retryGuaranteedTask(this.m_cnc);
                }
                catch (Exception e) {
                    LOG.error("ClientCommandSenderTask.requeue-failed", new Object[]{command});
                }
            }
        }
        if (notify_callback) {
            try {
                this.m_cnc.getCallback().commandSent(response);
            }
            catch (Throwable t) {
                LOG.warn(t, "ClientCommandSenderTask.callback-failed", new Object[]{response});
            }
        }
        if (this.m_response != null) {
            this.m_response[0] = response;
        }
    }

    public CommandAndCallback getCommandAndCallback() {
        return this.m_cnc;
    }

    protected CommandResponse send(ClientCommandSender sender, CommandAndCallback cnc) throws Throwable {
        return sender.send(cnc.getCommand());
    }

    void setClientCommandSender(ClientCommandSender sender) {
        this.m_sender = sender;
    }

    private boolean shouldCommandBeRetried(Command command, Throwable throwable) {
        if (this.m_isAsync && this.m_sender.isDeliveryGuaranteed(command)) {
            try {
                String RETRY_CONFIG_PROP = "rhq.retry";
                Properties config = command.getConfiguration();
                int retryCount = Integer.parseInt(config.getProperty("rhq.retry", "0"));
                if (retryCount == 0) {
                    StreamUtil.serialize((Serializable)command);
                }
                config.put("rhq.retry", String.valueOf(++retryCount));
                return this.isCannotConnectException(throwable) || retryCount <= this.m_sender.getConfiguration().maxRetries;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private boolean isCannotConnectException(Throwable t) {
        boolean yes;
        if (t == null) {
            return false;
        }
        boolean bl = yes = t instanceof ConnectException || t instanceof CannotConnectException;
        if (!yes) {
            yes = this.isCannotConnectException(t.getCause());
        }
        return yes;
    }
}

